/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level3.core;

import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMErrorMonitor;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DocumentBuilderSetting;

public final class infoset01
extends DOMTestCase {
    public infoset01(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        DocumentBuilderSetting[] settings = new DocumentBuilderSetting[]{DocumentBuilderSetting.namespaceAware};
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        this.setFactory(testFactory);
        String contentType = this.getContentType();
        this.preload(contentType, "barfoo", true);
    }

    @Override
    public void runTest() throws Throwable {
        DOMErrorMonitor errorMonitor = new DOMErrorMonitor();
        Document doc = this.load("barfoo", true);
        DOMConfiguration domConfig = doc.getDomConfig();
        domConfig.setParameter("infoset", Boolean.TRUE);
        domConfig.setParameter("error-handler", errorMonitor);
        NodeList pList = doc.getElementsByTagName("p");
        Element pElem = (Element)pList.item(0);
        EntityReference entRef = doc.createEntityReference("ent1");
        Node child = pElem.appendChild(entRef);
        doc.normalizeDocument();
        errorMonitor.assertLowerSeverity(this, "normalizeError", 2);
        pList = doc.getElementsByTagName("p");
        pElem = (Element)pList.item(0);
        child = pElem.getLastChild();
        this.assertNotNull("lastChildNotNull", child);
        String childName = child.getNodeName();
        this.assertEquals("firstChildName", "#text", childName);
        String childValue = child.getNodeValue();
        this.assertEquals("firstChildValue", "barfoo", childValue);
        DocumentType doctype = doc.getDoctype();
        NamedNodeMap entities = doctype.getEntities();
        Entity ent2 = (Entity)entities.getNamedItem("ent2");
        this.assertNotNull("ent2NotNull", ent2);
    }

    @Override
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/infoset01";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(infoset01.class, args);
    }
}

