/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level3.core;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;

public final class documentadoptnode06
extends DOMTestCase {
    public documentadoptnode06(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        super(factory);
        String contentType = this.getContentType();
        this.preload(contentType, "hc_staff", true);
    }

    @Override
    public void runTest() throws Throwable {
        DocumentType nullDocType = null;
        String xmlNS = "http://www.w3.org/XML/1998/namespace";
        Document doc = this.load("hc_staff", true);
        Element docElem = doc.getDocumentElement();
        String rootName = docElem.getTagName();
        String rootNS = docElem.getNamespaceURI();
        DOMImplementation domImpl = doc.getImplementation();
        Document newDoc = domImpl.createDocument(rootNS, rootName, nullDocType);
        Attr newAttr = doc.createAttributeNS(xmlNS, "xml:lang");
        Text newText = doc.createTextNode("Text Node");
        EntityReference newEntRef = doc.createEntityReference("alpha");
        newAttr.appendChild(newText);
        newAttr.appendChild(newEntRef);
        Attr adoptedAttr = (Attr)newDoc.adoptNode(newAttr);
        if (adoptedAttr != null) {
            String nodeName = adoptedAttr.getNodeName();
            String nodeNamespaceURI = adoptedAttr.getNamespaceURI();
            String nodePrefix = adoptedAttr.getPrefix();
            Element attrOwnerElem = adoptedAttr.getOwnerElement();
            boolean isSpecified = adoptedAttr.getSpecified();
            this.assertEquals("documentadoptnode06_nodeName", "xml:lang", nodeName);
            this.assertEquals("documentadoptnode06_namespaceURI", xmlNS, nodeNamespaceURI);
            this.assertEquals("documentadoptnode06_prefix", "xml", nodePrefix);
            this.assertNull("documentadoptnode06_ownerDoc", attrOwnerElem);
            this.assertTrue("documentadoptnode06_specified", isSpecified);
            NodeList nodeList = adoptedAttr.getChildNodes();
            Text adoptText = (Text)nodeList.item(0);
            EntityReference adoptEntRef = (EntityReference)nodeList.item(1);
            String adoptedTextNodeValue = adoptText.getNodeValue();
            String adoptedEntRefNodeValue = adoptEntRef.getNodeName();
            this.assertEquals("documentadoptnode06_TextNodeValue", "Text Node", adoptedTextNodeValue);
            this.assertEquals("documentadoptnode06_EntRefNodeValue", "alpha", adoptedEntRefNodeValue);
        }
    }

    @Override
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentadoptnode06";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(documentadoptnode06.class, args);
    }
}

