/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level2.core;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DocumentBuilderSetting;

public final class setAttributeNS04
extends DOMTestCase {
    public setAttributeNS04(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        DocumentBuilderSetting[] settings = new DocumentBuilderSetting[]{DocumentBuilderSetting.namespaceAware};
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        this.setFactory(testFactory);
        String contentType = this.getContentType();
        this.preload(contentType, "staffNS", true);
    }

    @Override
    public void runTest() throws Throwable {
        Document doc = this.load("staffNS", true);
        NodeList elementList = doc.getElementsByTagName("emp:address");
        Node testAddr = elementList.item(0);
        this.assertNotNull("empAddrNotNull", testAddr);
        ((Element)testAddr).setAttributeNS("http://www.nist.gov", "newprefix:zone", "newValue");
        Attr addrAttr = ((Element)testAddr).getAttributeNodeNS("http://www.nist.gov", "zone");
        String resultAttr = ((Element)testAddr).getAttributeNS("http://www.nist.gov", "zone");
        this.assertEquals("attrValue", "newValue", resultAttr);
        String resultNamespaceURI = addrAttr.getNamespaceURI();
        this.assertEquals("nsuri", "http://www.nist.gov", resultNamespaceURI);
        String resultLocalName = addrAttr.getLocalName();
        this.assertEquals("lname", "zone", resultLocalName);
        String resultPrefix = addrAttr.getPrefix();
        this.assertEquals("prefix", "newprefix", resultPrefix);
    }

    @Override
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/setAttributeNS04";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(setAttributeNS04.class, args);
    }
}

