/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level1.core;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;

public final class documenttypegetentities
extends DOMTestCase {
    public documenttypegetentities(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        super(factory);
        String contentType = this.getContentType();
        this.preload(contentType, "staff", false);
    }

    @Override
    public void runTest() throws Throwable {
        ArrayList<String> expectedResult = new ArrayList<String>();
        expectedResult.add("ent1");
        expectedResult.add("ent2");
        expectedResult.add("ent3");
        expectedResult.add("ent4");
        expectedResult.add("ent5");
        ArrayList<String> expectedResultSVG = new ArrayList<String>();
        expectedResultSVG.add("ent1");
        expectedResultSVG.add("ent2");
        expectedResultSVG.add("ent3");
        expectedResultSVG.add("ent4");
        expectedResultSVG.add("ent5");
        expectedResultSVG.add("svgunit");
        expectedResultSVG.add("svgtest");
        ArrayList<String> nameList = new ArrayList<String>();
        Document doc = this.load("staff", false);
        DocumentType docType = doc.getDoctype();
        this.assertNotNull("docTypeNotNull", docType);
        NamedNodeMap entityList = docType.getEntities();
        this.assertNotNull("entitiesNotNull", entityList);
        int indexN1007B = 0;
        while (indexN1007B < entityList.getLength()) {
            Node entity = entityList.item(indexN1007B);
            String name = entity.getNodeName();
            nameList.add(name);
            ++indexN1007B;
        }
        if ("image/svg+xml".equals(this.getContentType())) {
            this.assertEquals("entityNamesSVG", expectedResultSVG, nameList);
        } else {
            this.assertEquals("entityNames", expectedResult, nameList);
        }
    }

    @Override
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/documenttypegetentities";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(documenttypegetentities.class, args);
    }
}

