/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts;

import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DocumentBuilderSetting;

public abstract class DocumentBuilderSettingStrategy {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final DocumentBuilderSettingStrategy coalescing = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            factory.setCoalescing(value);
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return factory.isCoalescing();
        }
    };
    public static final DocumentBuilderSettingStrategy expandEntityReferences = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            factory.setExpandEntityReferences(value);
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return factory.isExpandEntityReferences();
        }
    };
    public static final DocumentBuilderSettingStrategy ignoringElementContentWhitespace = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            factory.setIgnoringElementContentWhitespace(value);
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return factory.isIgnoringElementContentWhitespace();
        }
    };
    public static final DocumentBuilderSettingStrategy ignoringComments = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            if (value) {
                throw new DOMTestIncompatibleException(new Exception("ignoreComments=true not supported"), DocumentBuilderSetting.ignoringComments);
            }
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return false;
        }
    };
    public static final DocumentBuilderSettingStrategy namespaceAware = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            factory.setNamespaceAware(value);
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return factory.isNamespaceAware();
        }
    };
    public static final DocumentBuilderSettingStrategy validating = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            factory.setValidating(value);
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return factory.isValidating();
        }
    };
    public static final DocumentBuilderSettingStrategy signed = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            if (!value) {
                throw new DOMTestIncompatibleException(null, DocumentBuilderSetting.notSigned);
            }
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return true;
        }
    };
    public static final DocumentBuilderSettingStrategy hasNullString = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            if (!value) {
                throw new DOMTestIncompatibleException(null, DocumentBuilderSetting.notHasNullString);
            }
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            return true;
        }
    };
    public static final DocumentBuilderSettingStrategy schemaValidating = new DocumentBuilderSettingStrategy(){

        @Override
        public void applySetting(DocumentBuilderFactory factory, boolean value) throws DOMTestIncompatibleException {
            if (value) {
                factory.setNamespaceAware(true);
                factory.setValidating(true);
                factory.setAttribute(DocumentBuilderSettingStrategy.JAXP_SCHEMA_LANGUAGE, DocumentBuilderSettingStrategy.W3C_XML_SCHEMA);
            } else {
                factory.setAttribute(DocumentBuilderSettingStrategy.JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/TR/REC-xml");
            }
        }

        @Override
        public boolean hasSetting(DOMTestDocumentBuilderFactory factory) {
            try {
                if (factory.isValidating()) {
                    Method getAttrMethod = factory.getClass().getMethod("getAttribute", String.class);
                    String val = (String)getAttrMethod.invoke((Object)factory, DocumentBuilderSettingStrategy.JAXP_SCHEMA_LANGUAGE);
                    return DocumentBuilderSettingStrategy.W3C_XML_SCHEMA.equals(val);
                }
            }
            catch (Exception exception) {}
            return false;
        }

        @Override
        public boolean hasConflict(DocumentBuilderSettingStrategy other) {
            return other == this || other == namespaceAware || other == validating;
        }
    };

    protected DocumentBuilderSettingStrategy() {
    }

    public boolean hasConflict(DocumentBuilderSettingStrategy other) {
        return other == this;
    }

    public abstract void applySetting(DocumentBuilderFactory var1, boolean var2) throws DOMTestIncompatibleException;

    public abstract boolean hasSetting(DOMTestDocumentBuilderFactory var1);
}

