/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.w3c;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.axiom.testutils.suite.MatrixTestSuiteBuilder;
import org.apache.axiom.ts.dom.DocumentBuilderFactoryFactory;
import org.apache.axiom.ts.dom.w3c.DOMFeature;
import org.apache.axiom.ts.dom.w3c.DOMTSClassVisitor;
import org.apache.axiom.ts.dom.w3c.DOMTestDocumentBuilderFactoryImpl;
import org.apache.axiom.ts.dom.w3c.JUnitTestFramework;
import org.apache.axiom.ts.dom.w3c.W3CTestCase;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DOMTestSink;
import org.w3c.domts.DOMTestSuite;
import org.w3c.domts.DocumentBuilderSetting;

public abstract class W3CDOMTestSuiteBuilder
extends MatrixTestSuiteBuilder {
    private final DocumentBuilderFactoryFactory dbff;
    private final Set<DOMFeature> unsupportedFeatures;

    public W3CDOMTestSuiteBuilder(DocumentBuilderFactoryFactory dbff, DOMFeature ... unsupportedFeatures) {
        this.dbff = dbff;
        this.unsupportedFeatures = new HashSet<DOMFeature>(Arrays.asList(unsupportedFeatures));
    }

    protected final void addTests() {
        DOMTestSuite suite;
        DOMTestDocumentBuilderFactoryImpl factory;
        try {
            factory = new DOMTestDocumentBuilderFactoryImpl(this.dbff, new DocumentBuilderSetting[]{DocumentBuilderSetting.notCoalescing, DocumentBuilderSetting.notExpandEntityReferences, DocumentBuilderSetting.notIgnoringElementContentWhitespace, DocumentBuilderSetting.namespaceAware, DocumentBuilderSetting.notValidating});
        }
        catch (DOMTestIncompatibleException ex) {
            throw new Error(ex);
        }
        try {
            suite = this.createDOMTestSuite(factory);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        suite.build(new DOMTestSink(){

            @Override
            public void addTest(Class testClass) {
                try {
                    DOMTestCase test;
                    if (!W3CDOMTestSuiteBuilder.this.unsupportedFeatures.isEmpty()) {
                        HashSet<DOMFeature> usedFeatures = new HashSet<DOMFeature>();
                        DOMFeature.matchFeatures(testClass, usedFeatures);
                        ClassReader classReader = new ClassReader(testClass.getResourceAsStream(String.valueOf(testClass.getSimpleName()) + ".class"));
                        DOMTSClassVisitor cv = new DOMTSClassVisitor(usedFeatures);
                        classReader.accept((ClassVisitor)cv, 6);
                        usedFeatures.retainAll(W3CDOMTestSuiteBuilder.this.unsupportedFeatures);
                        if (!usedFeatures.isEmpty()) {
                            return;
                        }
                    }
                    Constructor<DOMTestCase> testConstructor = testClass.asSubclass(DOMTestCase.class).getConstructor(DOMTestDocumentBuilderFactory.class);
                    try {
                        test = testConstructor.newInstance(factory);
                    }
                    catch (InvocationTargetException ex) {
                        throw ex.getTargetException();
                    }
                    test.setFramework(JUnitTestFramework.INSTANCE);
                    W3CDOMTestSuiteBuilder.this.addTest(new W3CTestCase(test));
                }
                catch (Throwable ex) {
                    throw new Error(ex);
                }
            }
        });
    }

    protected abstract DOMTestSuite createDOMTestSuite(DOMTestDocumentBuilderFactory var1) throws Exception;
}

