/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestLookupNamespaceURIImplicit
extends DOMTestCase {
    public TestLookupNamespaceURIImplicit(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        String ns1 = "http://apache/axiom/dom/ns1";
        String element1Name = "ele1";
        String ns2 = "http://apache/axiom/dom/ns2";
        String element2Name = "ns2:ele2";
        String pref2 = "ns2";
        String element3Name = "ele3";
        String nsParent = "http://apache/axiom/dom/parent";
        String parentName = "p:parent";
        String prefParent = "p";
        Document doc = this.dbf.newDocumentBuilder().newDocument();
        Element parent = doc.createElementNS(nsParent, parentName);
        Element element1 = doc.createElementNS(ns1, element1Name);
        parent.appendChild(element1);
        Element element2 = doc.createElementNS(ns2, element2Name);
        parent.appendChild(element2);
        Element element3 = doc.createElement(element3Name);
        element3.setAttributeNS("urn:test", "ns3:attr", "value");
        parent.appendChild(element3);
        TestLookupNamespaceURIImplicit.assertEquals((String)"Incorrect default namespace returned for the element", (String)ns1, (String)element1.lookupNamespaceURI(null));
        TestLookupNamespaceURIImplicit.assertNull((Object)element1.lookupNamespaceURI("ns0"));
        TestLookupNamespaceURIImplicit.assertEquals((String)"Incorrect namespace returned for the element", (String)ns2, (String)element2.lookupNamespaceURI(pref2));
        TestLookupNamespaceURIImplicit.assertNull((Object)element2.lookupNamespaceURI("ns0"));
        TestLookupNamespaceURIImplicit.assertNull((Object)element2.lookupNamespaceURI(null));
        TestLookupNamespaceURIImplicit.assertEquals((String)"Incorrect namespace returned for the given prefix", (String)nsParent, (String)element3.lookupNamespaceURI(prefParent));
        TestLookupNamespaceURIImplicit.assertNull((Object)element3.lookupNamespaceURI("ns3"));
    }
}

