/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.suite.MatrixTestSuiteBuilder;
import org.apache.axiom.ts.dom.DocumentBuilderFactoryFactory;
import org.apache.axiom.ts.dom.attr.TestCloneNode;
import org.apache.axiom.ts.dom.attr.TestGetChildNodes;
import org.apache.axiom.ts.dom.attr.TestGetFirstChild;
import org.apache.axiom.ts.dom.attr.TestGetValueWithMultipleChildren;
import org.apache.axiom.ts.dom.attr.TestLookupNamespaceURIWithoutOwnerElement;
import org.apache.axiom.ts.dom.attr.TestSetPrefixNotNullWithNamespace;
import org.apache.axiom.ts.dom.attr.TestSetPrefixNotNullWithoutNamespace;
import org.apache.axiom.ts.dom.attr.TestSetPrefixNullWithNamespace;
import org.apache.axiom.ts.dom.builder.TestParseURI;
import org.apache.axiom.ts.dom.builder.TestWhitespaceAroundDocumentElement;
import org.apache.axiom.ts.dom.document.TestAdoptNode;
import org.apache.axiom.ts.dom.document.TestAdoptNodeToSameDocument;
import org.apache.axiom.ts.dom.document.TestAdoptNodeWithParent;
import org.apache.axiom.ts.dom.document.TestAllowedChildren;
import org.apache.axiom.ts.dom.document.TestAppendChildForeignImplementation;
import org.apache.axiom.ts.dom.document.TestCreateAttribute;
import org.apache.axiom.ts.dom.document.TestCreateAttributeNS;
import org.apache.axiom.ts.dom.document.TestCreateAttributeNSInvalid;
import org.apache.axiom.ts.dom.document.TestCreateAttributeNSWithoutNamespace;
import org.apache.axiom.ts.dom.document.TestCreateCDATASection;
import org.apache.axiom.ts.dom.document.TestCreateElement;
import org.apache.axiom.ts.dom.document.TestCreateElementNS;
import org.apache.axiom.ts.dom.document.TestCreateElementNSWithInvalidName;
import org.apache.axiom.ts.dom.document.TestCreateElementNSWithoutNamespace;
import org.apache.axiom.ts.dom.document.TestCreateEntityReference;
import org.apache.axiom.ts.dom.document.TestCreateText;
import org.apache.axiom.ts.dom.document.TestDocumentSiblings;
import org.apache.axiom.ts.dom.document.TestGetDomConfigDefaults;
import org.apache.axiom.ts.dom.document.TestGetOwnerDocument;
import org.apache.axiom.ts.dom.document.TestLookupNamespaceURIWithEmptyDocument;
import org.apache.axiom.ts.dom.document.TestLookupPrefixWithEmptyDocument;
import org.apache.axiom.ts.dom.document.TestNormalizeDocumentNamespace;
import org.apache.axiom.ts.dom.document.TestTransformerWithIdentityStylesheet;
import org.apache.axiom.ts.dom.document.TestTransformerWithStylesheet;
import org.apache.axiom.ts.dom.document.TestValidator;
import org.apache.axiom.ts.dom.documentfragment.TestCloneNodeDeep;
import org.apache.axiom.ts.dom.documentfragment.TestCloneNodeShallow;
import org.apache.axiom.ts.dom.documentfragment.TestLookupNamespaceURI;
import org.apache.axiom.ts.dom.documentfragment.TestLookupPrefix;
import org.apache.axiom.ts.dom.documenttype.TestWithParser1;
import org.apache.axiom.ts.dom.documenttype.TestWithParser2;
import org.apache.axiom.ts.dom.element.TestAppendChild;
import org.apache.axiom.ts.dom.element.TestAppendChildCyclic;
import org.apache.axiom.ts.dom.element.TestAppendChildSelf;
import org.apache.axiom.ts.dom.element.TestAppendChildWrongDocument;
import org.apache.axiom.ts.dom.element.TestAttributes;
import org.apache.axiom.ts.dom.element.TestAttributes2;
import org.apache.axiom.ts.dom.element.TestAttributes3;
import org.apache.axiom.ts.dom.element.TestAttributes4;
import org.apache.axiom.ts.dom.element.TestCloneNodeWithAttributeHavingMultipleChildren;
import org.apache.axiom.ts.dom.element.TestCloneNodeWithAttributes;
import org.apache.axiom.ts.dom.element.TestGetElementsByTagName;
import org.apache.axiom.ts.dom.element.TestGetElementsByTagNameNS;
import org.apache.axiom.ts.dom.element.TestGetElementsByTagNameRecursive;
import org.apache.axiom.ts.dom.element.TestGetElementsByTagNameWithNamespaces;
import org.apache.axiom.ts.dom.element.TestGetElementsByTagNameWithWildcard;
import org.apache.axiom.ts.dom.element.TestGetNamespaceURIWithNoNamespace;
import org.apache.axiom.ts.dom.element.TestGetPrefixWithDefaultNamespace;
import org.apache.axiom.ts.dom.element.TestGetTextContent;
import org.apache.axiom.ts.dom.element.TestImportNode;
import org.apache.axiom.ts.dom.element.TestInsertBefore;
import org.apache.axiom.ts.dom.element.TestInsertBeforeWithDocumentFragment;
import org.apache.axiom.ts.dom.element.TestLookupNamespaceURIDefaultBindings;
import org.apache.axiom.ts.dom.element.TestLookupNamespaceURIExplicit;
import org.apache.axiom.ts.dom.element.TestLookupNamespaceURIImplicit;
import org.apache.axiom.ts.dom.element.TestLookupNamespaceURINamespaceDeclarationAsNSUnawareAttribute;
import org.apache.axiom.ts.dom.element.TestLookupNamespaceURIXercesJ1586;
import org.apache.axiom.ts.dom.element.TestLookupPrefixDefaultBindings;
import org.apache.axiom.ts.dom.element.TestLookupPrefixEmptyNamespace;
import org.apache.axiom.ts.dom.element.TestLookupPrefixExplicitMasked;
import org.apache.axiom.ts.dom.element.TestLookupPrefixImplicitMasked;
import org.apache.axiom.ts.dom.element.TestRemoveAttributeNodeForeignImplementation;
import org.apache.axiom.ts.dom.element.TestRemoveAttributeNodeNotOwner;
import org.apache.axiom.ts.dom.element.TestRemoveFirstChild;
import org.apache.axiom.ts.dom.element.TestRemoveLastChild;
import org.apache.axiom.ts.dom.element.TestRemoveSingleChild;
import org.apache.axiom.ts.dom.element.TestReplaceChildCyclic;
import org.apache.axiom.ts.dom.element.TestReplaceChildFirst;
import org.apache.axiom.ts.dom.element.TestReplaceChildFirstWithDocumentFragment;
import org.apache.axiom.ts.dom.element.TestReplaceChildLast;
import org.apache.axiom.ts.dom.element.TestReplaceChildLastWithDocumentFragment;
import org.apache.axiom.ts.dom.element.TestReplaceChildMiddle;
import org.apache.axiom.ts.dom.element.TestReplaceChildMiddleWithDocumentFragment;
import org.apache.axiom.ts.dom.element.TestReplaceChildNotFound;
import org.apache.axiom.ts.dom.element.TestReplaceChildNullNewChild;
import org.apache.axiom.ts.dom.element.TestReplaceChildSingle;
import org.apache.axiom.ts.dom.element.TestReplaceChildWrongDocument;
import org.apache.axiom.ts.dom.element.TestSetAttributeNS;
import org.apache.axiom.ts.dom.element.TestSetAttributeNSExisting;
import org.apache.axiom.ts.dom.element.TestSetAttributeNSExistingDefaultNamespaceDeclaration;
import org.apache.axiom.ts.dom.element.TestSetAttributeNSInvalid;
import org.apache.axiom.ts.dom.element.TestSetAttributeNodeNSForeignImplementation;
import org.apache.axiom.ts.dom.element.TestSetAttributeNodeNSInUse;
import org.apache.axiom.ts.dom.element.TestSetAttributeNodeNSReplace;
import org.apache.axiom.ts.dom.element.TestSetAttributeNodeNSWrongDocument;
import org.apache.axiom.ts.dom.element.TestSetAttributeNodeWrongDocument;
import org.apache.axiom.ts.dom.element.TestSetPrefixNull;
import org.apache.axiom.ts.dom.element.TestSetTextContent;
import org.apache.axiom.ts.dom.element.attributes.TestSetNamedItemNSWrongDocument;
import org.apache.axiom.ts.dom.element.attributes.TestSetNamedItemWrongDocument;
import org.apache.axiom.ts.dom.text.TestAppendData;
import org.apache.axiom.ts.dom.text.TestGetLength;
import org.apache.axiom.ts.dom.text.TestGetWholeText;
import org.apache.axiom.ts.dom.text.TestGetWholeTextWithCDATASection;
import org.apache.axiom.ts.dom.text.TestGetWholeTextWithComment;
import org.apache.axiom.ts.dom.text.TestLookupNamespaceURIWithoutParent;
import org.apache.axiom.ts.dom.text.TestReplaceDataAppend;
import org.apache.axiom.ts.dom.text.TestSetPrefix;
import org.apache.axiom.ts.dom.text.TestSplitText;
import org.apache.axiom.ts.dom.text.TestSplitTextWithoutParent;
import org.apache.axiom.ts.jaxp.DOMImplementation;
import org.apache.axiom.ts.jaxp.XSLTImplementation;
import org.apache.axiom.ts.xml.XMLSample;

public final class DOMTestSuiteBuilder
extends MatrixTestSuiteBuilder {
    private static final QName[] validAttrQNames = new QName[]{new QName("urn:ns2", "attr", "q"), new QName("", "attr", ""), new QName("http://www.w3.org/2000/xmlns/", "ns", "xmlns"), new QName("http://www.w3.org/2000/xmlns/", "xmlns", "")};
    private static final QName[] invalidAttrQNames = new QName[]{new QName("http://www.w3.org/2000/xmlns/", "attr", ""), new QName("http://www.w3.org/2000/xmlns/", "attr", "p"), new QName("urn:test", "p", "xmlns"), new QName("", "xmlns", "")};
    private final DocumentBuilderFactoryFactory dbff;

    public DOMTestSuiteBuilder(DocumentBuilderFactoryFactory dbff) {
        this.dbff = dbff;
    }

    protected void addTests() {
        DocumentBuilderFactory dbf = this.dbff.newInstance();
        dbf.setNamespaceAware(true);
        this.addTest(new TestCloneNode(dbf, true));
        this.addTest(new TestCloneNode(dbf, false));
        this.addTest(new TestGetChildNodes(dbf));
        this.addTest(new TestGetFirstChild(dbf));
        this.addTest(new org.apache.axiom.ts.dom.attr.TestGetNamespaceURIWithNoNamespace(dbf));
        this.addTest(new TestGetValueWithMultipleChildren(dbf));
        this.addTest(new TestLookupNamespaceURIWithoutOwnerElement(dbf));
        this.addTest(new TestSetPrefixNotNullWithNamespace(dbf));
        this.addTest(new TestSetPrefixNotNullWithoutNamespace(dbf));
        this.addTest(new TestSetPrefixNullWithNamespace(dbf));
        this.addTest(new TestParseURI(dbf));
        this.addTest(new TestWhitespaceAroundDocumentElement(dbf));
        this.addTest(new TestAdoptNode(dbf));
        this.addTest(new TestAdoptNodeToSameDocument(dbf));
        this.addTest(new TestAdoptNodeWithParent(dbf));
        this.addTest(new TestAllowedChildren(dbf));
        this.addTest(new TestAppendChildForeignImplementation(dbf));
        this.addTest(new org.apache.axiom.ts.dom.document.TestAppendChildWrongDocument(dbf));
        for (XMLSample file : Multiton.getInstances(XMLSample.class)) {
            this.addTest(new org.apache.axiom.ts.dom.document.TestCloneNode(dbf, file));
        }
        this.addTest(new TestCreateAttribute(dbf));
        int i = 0;
        while (i < validAttrQNames.length) {
            this.addTest(new TestCreateAttributeNS(dbf, validAttrQNames[i]));
            ++i;
        }
        i = 0;
        while (i < invalidAttrQNames.length) {
            this.addTest(new TestCreateAttributeNSInvalid(dbf, invalidAttrQNames[i]));
            ++i;
        }
        this.addTest(new TestCreateAttributeNSWithoutNamespace(dbf));
        this.addTest(new TestCreateCDATASection(dbf));
        this.addTest(new TestCreateElement(dbf));
        this.addTest(new TestCreateElementNS(dbf));
        this.addTest(new TestCreateElementNSWithInvalidName(dbf));
        this.addTest(new TestCreateElementNSWithoutNamespace(dbf));
        this.addTest(new TestCreateEntityReference(dbf));
        this.addTest(new TestCreateText(dbf));
        this.addTest(new TestDocumentSiblings(dbf));
        this.addTest(new TestGetDomConfigDefaults(dbf));
        this.addTest(new TestGetOwnerDocument(dbf));
        this.addTest(new org.apache.axiom.ts.dom.document.TestLookupNamespaceURI(dbf));
        this.addTest(new TestLookupNamespaceURIWithEmptyDocument(dbf));
        this.addTest(new TestLookupPrefixWithEmptyDocument(dbf));
        this.addTest(new TestNormalizeDocumentNamespace(dbf));
        for (XSLTImplementation xsltImplementation : Multiton.getInstances(XSLTImplementation.class)) {
            this.addTest(new TestTransformerWithIdentityStylesheet(dbf, xsltImplementation));
            this.addTest(new TestTransformerWithStylesheet(dbf, xsltImplementation));
        }
        this.addTest(new TestValidator(dbf));
        this.addTest(new TestCloneNodeDeep(dbf));
        this.addTest(new TestCloneNodeShallow(dbf));
        this.addTest(new TestLookupNamespaceURI(dbf));
        this.addTest(new TestLookupPrefix(dbf));
        this.addTest(new TestWithParser1(dbf));
        this.addTest(new TestWithParser2(dbf));
        this.addTest(new TestAppendChild(dbf));
        this.addTest(new TestAppendChildCyclic(dbf));
        this.addTest(new TestAppendChildSelf(dbf));
        this.addTest(new TestAppendChildWrongDocument(dbf));
        this.addTest(new TestAttributes(dbf));
        this.addTest(new TestAttributes2(dbf));
        this.addTest(new TestAttributes3(dbf));
        this.addTest(new TestAttributes4(dbf));
        this.addTest(new org.apache.axiom.ts.dom.element.TestCloneNode(dbf));
        this.addTest(new TestCloneNodeWithAttributeHavingMultipleChildren(dbf));
        this.addTest(new TestCloneNodeWithAttributes(dbf, true));
        this.addTest(new TestCloneNodeWithAttributes(dbf, false));
        this.addTest(new TestGetElementsByTagName(dbf));
        this.addTest(new TestGetElementsByTagNameNS(dbf));
        this.addTest(new TestGetElementsByTagNameRecursive(dbf));
        this.addTest(new TestGetElementsByTagNameWithNamespaces(dbf));
        this.addTest(new TestGetElementsByTagNameWithWildcard(dbf));
        this.addTest(new TestGetNamespaceURIWithNoNamespace(dbf));
        this.addTest(new TestGetPrefixWithDefaultNamespace(dbf));
        this.addTest(new TestGetTextContent(dbf));
        for (XMLSample file : Multiton.getInstances(XMLSample.class)) {
            for (DOMImplementation from : Multiton.getInstances(DOMImplementation.class)) {
                this.addTest(new TestImportNode(dbf, file, from));
            }
        }
        this.addTest(new TestInsertBefore(dbf));
        this.addTest(new TestInsertBeforeWithDocumentFragment(dbf));
        this.addTest(new TestLookupNamespaceURIDefaultBindings(dbf));
        this.addTest(new TestLookupNamespaceURIExplicit(dbf));
        this.addTest(new TestLookupNamespaceURIImplicit(dbf));
        this.addTest(new TestLookupNamespaceURINamespaceDeclarationAsNSUnawareAttribute(dbf));
        this.addTest(new TestLookupNamespaceURIXercesJ1586(dbf));
        this.addTest(new TestLookupPrefixDefaultBindings(dbf));
        this.addTest(new TestLookupPrefixEmptyNamespace(dbf));
        this.addTest(new TestLookupPrefixExplicitMasked(dbf));
        this.addTest(new TestLookupPrefixImplicitMasked(dbf));
        this.addTest(new TestRemoveAttributeNodeForeignImplementation(dbf));
        this.addTest(new TestRemoveAttributeNodeNotOwner(dbf));
        this.addTest(new TestRemoveFirstChild(dbf));
        this.addTest(new TestRemoveLastChild(dbf));
        this.addTest(new TestRemoveSingleChild(dbf));
        this.addTest(new TestReplaceChildCyclic(dbf));
        this.addTest(new TestReplaceChildFirst(dbf, false));
        this.addTest(new TestReplaceChildFirst(dbf, true));
        this.addTest(new TestReplaceChildFirstWithDocumentFragment(dbf));
        this.addTest(new TestReplaceChildLast(dbf, false));
        this.addTest(new TestReplaceChildLast(dbf, true));
        this.addTest(new TestReplaceChildLastWithDocumentFragment(dbf));
        this.addTest(new TestReplaceChildMiddle(dbf, false));
        this.addTest(new TestReplaceChildMiddle(dbf, true));
        this.addTest(new TestReplaceChildMiddleWithDocumentFragment(dbf));
        this.addTest(new TestReplaceChildNotFound(dbf));
        this.addTest(new TestReplaceChildNullNewChild(dbf));
        this.addTest(new TestReplaceChildSingle(dbf, false));
        this.addTest(new TestReplaceChildSingle(dbf, true));
        this.addTest(new TestReplaceChildWrongDocument(dbf));
        this.addTest(new TestSetAttributeNodeNSForeignImplementation(dbf));
        this.addTest(new TestSetAttributeNodeNSInUse(dbf));
        this.addTest(new TestSetAttributeNodeNSReplace(dbf));
        this.addTest(new TestSetAttributeNodeNSWrongDocument(dbf));
        this.addTest(new TestSetAttributeNodeWrongDocument(dbf));
        i = 0;
        while (i < validAttrQNames.length) {
            this.addTest(new TestSetAttributeNS(dbf, validAttrQNames[i], "value"));
            ++i;
        }
        this.addTest(new TestSetAttributeNSExisting(dbf));
        this.addTest(new TestSetAttributeNSExistingDefaultNamespaceDeclaration(dbf));
        i = 0;
        while (i < invalidAttrQNames.length) {
            this.addTest(new TestSetAttributeNSInvalid(dbf, invalidAttrQNames[i]));
            ++i;
        }
        this.addTest(new org.apache.axiom.ts.dom.element.TestSetPrefixNotNullWithNamespace(dbf));
        this.addTest(new org.apache.axiom.ts.dom.element.TestSetPrefixNotNullWithoutNamespace(dbf));
        this.addTest(new TestSetPrefixNull(dbf));
        this.addTest(new TestSetTextContent(dbf));
        this.addTest(new TestSetNamedItemNSWrongDocument(dbf));
        this.addTest(new TestSetNamedItemWrongDocument(dbf));
        this.addTest(new TestAppendData(dbf));
        this.addTest(new org.apache.axiom.ts.dom.text.TestGetChildNodes(dbf));
        this.addTest(new TestGetLength(dbf));
        this.addTest(new TestGetWholeText(dbf));
        this.addTest(new TestGetWholeTextWithCDATASection(dbf));
        this.addTest(new TestGetWholeTextWithComment(dbf));
        this.addTest(new TestLookupNamespaceURIWithoutParent(dbf));
        this.addTest(new TestReplaceDataAppend(dbf));
        this.addTest(new TestSetPrefix(dbf));
        this.addTest(new TestSplitText(dbf));
        this.addTest(new TestSplitTextWithoutParent(dbf));
    }
}

