/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DOMTestLoadException;
import org.w3c.domts.DocumentBuilderSetting;

public abstract class DOMTestDocumentBuilderFactory {
    private final DocumentBuilderSetting[] settings;

    public DOMTestDocumentBuilderFactory(DocumentBuilderSetting[] settings) throws DOMTestIncompatibleException {
        this.settings = settings == null ? new DocumentBuilderSetting[0] : (DocumentBuilderSetting[])settings.clone();
    }

    public abstract DOMTestDocumentBuilderFactory newInstance(DocumentBuilderSetting[] var1) throws DOMTestIncompatibleException;

    public abstract DOMImplementation getDOMImplementation();

    public abstract boolean hasFeature(String var1, String var2);

    public abstract Document load(URL var1) throws DOMTestLoadException;

    public Object createXPathEvaluator(Document doc) {
        try {
            Method getFeatureMethod = doc.getClass().getMethod("getFeature", String.class, String.class);
            if (getFeatureMethod != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = "XPath";
                return getFeatureMethod.invoke((Object)doc, objectArray);
            }
        }
        catch (Exception exception) {}
        return doc;
    }

    protected DocumentBuilderSetting[] mergeSettings(DocumentBuilderSetting[] newSettings) {
        if (newSettings == null) {
            return (DocumentBuilderSetting[])this.settings.clone();
        }
        ArrayList<DocumentBuilderSetting> mergedSettings = new ArrayList<DocumentBuilderSetting>(this.settings.length + newSettings.length);
        int i = 0;
        while (i < newSettings.length) {
            mergedSettings.add(newSettings[i]);
            ++i;
        }
        i = 0;
        while (i < this.settings.length) {
            DocumentBuilderSetting setting = this.settings[i];
            boolean hasConflict = false;
            int j = 0;
            while (j < newSettings.length) {
                DocumentBuilderSetting newSetting = newSettings[j];
                if (newSetting.hasConflict(setting) || setting.hasConflict(newSetting)) {
                    hasConflict = true;
                    break;
                }
                ++j;
            }
            if (!hasConflict) {
                mergedSettings.add(setting);
            }
            ++i;
        }
        DocumentBuilderSetting[] mergedArray = new DocumentBuilderSetting[mergedSettings.size()];
        int i2 = 0;
        while (i2 < mergedSettings.size()) {
            mergedArray[i2] = (DocumentBuilderSetting)mergedSettings.get(i2);
            ++i2;
        }
        return mergedArray;
    }

    public String addExtension(String testFileName) {
        String contentType = this.getContentType();
        if ("text/html".equals(contentType)) {
            return String.valueOf(testFileName) + ".html";
        }
        if ("image/svg+xml".equals(contentType)) {
            return String.valueOf(testFileName) + ".svg";
        }
        if ("application/xhtml+xml".equals(contentType)) {
            return String.valueOf(testFileName) + ".xhtml";
        }
        return String.valueOf(testFileName) + ".xml";
    }

    public abstract boolean isCoalescing();

    public abstract boolean isExpandEntityReferences();

    public abstract boolean isIgnoringElementContentWhitespace();

    public abstract boolean isNamespaceAware();

    public abstract boolean isValidating();

    public String getContentType() {
        return System.getProperty("org.w3c.domts.contentType", "text/xml");
    }

    public final DocumentBuilderSetting[] getActualSettings() {
        DocumentBuilderSetting[] allSettings = new DocumentBuilderSetting[]{DocumentBuilderSetting.coalescing, DocumentBuilderSetting.expandEntityReferences, DocumentBuilderSetting.hasNullString, DocumentBuilderSetting.ignoringElementContentWhitespace, DocumentBuilderSetting.namespaceAware, DocumentBuilderSetting.signed, DocumentBuilderSetting.validating, DocumentBuilderSetting.notCoalescing, DocumentBuilderSetting.notExpandEntityReferences, DocumentBuilderSetting.notHasNullString, DocumentBuilderSetting.notIgnoringElementContentWhitespace, DocumentBuilderSetting.notNamespaceAware, DocumentBuilderSetting.notSigned, DocumentBuilderSetting.notValidating};
        ArrayList<DocumentBuilderSetting> list = new ArrayList<DocumentBuilderSetting>(allSettings.length / 2);
        int i = 0;
        while (i < allSettings.length) {
            if (allSettings[i].hasSetting(this)) {
                list.add(allSettings[i]);
            }
            ++i;
        }
        DocumentBuilderSetting[] settings = new DocumentBuilderSetting[list.size()];
        int i2 = 0;
        while (i2 < settings.length) {
            settings[i2] = (DocumentBuilderSetting)list.get(i2);
            ++i2;
        }
        return settings;
    }
}

