/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.text;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TestSplitText
extends DOMTestCase {
    public TestSplitText(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        String textValue = "temp text value";
        Document doc = this.dbf.newDocumentBuilder().newDocument();
        Element element = doc.createElement("test");
        Text txt = doc.createTextNode(textValue);
        element.appendChild(txt);
        txt.splitText(3);
        TestSplitText.assertNotNull((String)"Text value missing in the original Text node", (Object)txt.getNodeValue());
        TestSplitText.assertNotNull((String)"Sibling missing after split", (Object)txt.getNextSibling());
        TestSplitText.assertNotNull((String)"Text value missing in the new split Text node", (Object)txt.getNextSibling().getNodeValue());
        TestSplitText.assertEquals((String)"Incorrect split point", (String)textValue.substring(0, 3), (String)txt.getNodeValue());
        TestSplitText.assertEquals((String)"Incorrect split point", (String)textValue.substring(3, textValue.length()), (String)txt.getNextSibling().getNodeValue());
    }
}

