/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.element;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestLookupNamespaceURIExplicit
extends DOMTestCase {
    public TestLookupNamespaceURIExplicit(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element e1 = document.createElementNS("urn:ns0", "ns0:e1");
        e1.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:ns1");
        e1.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:p", "urn:ns2");
        e1.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:q", "urn:ns4");
        Element e2 = document.createElementNS("urn:ns0", "ns0:e2");
        e2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:p", "urn:ns3");
        e2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:q", "");
        e1.appendChild(e2);
        Element e3 = document.createElementNS("urn:ns0", "ns0:e3");
        e3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        e3.setAttributeNS("urn:test", "ns:p", "value");
        e3.setAttributeNS(null, "q", "value");
        e2.appendChild(e3);
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns1", (String)e1.lookupNamespaceURI(null));
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns1", (String)e2.lookupNamespaceURI(null));
        TestLookupNamespaceURIExplicit.assertNull((Object)e3.lookupNamespaceURI(null));
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns2", (String)e1.lookupNamespaceURI("p"));
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns3", (String)e2.lookupNamespaceURI("p"));
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns3", (String)e3.lookupNamespaceURI("p"));
        TestLookupNamespaceURIExplicit.assertEquals((String)"urn:ns4", (String)e1.lookupNamespaceURI("q"));
        TestLookupNamespaceURIExplicit.assertEquals(null, (String)e2.lookupNamespaceURI("q"));
        TestLookupNamespaceURIExplicit.assertEquals(null, (String)e3.lookupNamespaceURI("q"));
    }
}

