/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.document;

import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class TestNormalizeDocumentNamespace
extends DOMTestCase {
    public TestNormalizeDocumentNamespace(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document document = this.dbf.newDocumentBuilder().newDocument();
        Element element = document.createElementNS("urn:ns", "root");
        document.appendChild(element);
        DOMConfiguration domConfig = document.getDomConfig();
        domConfig.setParameter("split-cdata-sections", Boolean.FALSE);
        domConfig.setParameter("well-formed", Boolean.FALSE);
        domConfig.setParameter("namespaces", Boolean.TRUE);
        document.normalizeDocument();
        NamedNodeMap attributes = element.getAttributes();
        TestNormalizeDocumentNamespace.assertEquals((int)1, (int)attributes.getLength());
        Attr attr = (Attr)attributes.item(0);
        TestNormalizeDocumentNamespace.assertNull((Object)attr.getPrefix());
        TestNormalizeDocumentNamespace.assertEquals((String)"xmlns", (String)attr.getLocalName());
        TestNormalizeDocumentNamespace.assertEquals((String)"http://www.w3.org/2000/xmlns/", (String)attr.getNamespaceURI());
        TestNormalizeDocumentNamespace.assertEquals((String)"urn:ns", (String)attr.getValue());
    }
}

