/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.builder;

import com.google.common.truth.Truth;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class TestWhitespaceAroundDocumentElement
extends DOMTestCase {
    public TestWhitespaceAroundDocumentElement(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        Document doc = this.dbf.newDocumentBuilder().parse(new InputSource(new StringReader(" <!-- --> <root/> ")));
        Node child = doc.getFirstChild();
        do {
            Truth.assertThat((Object)child).isNotInstanceOf(Text.class);
        } while ((child = child.getNextSibling()) != null);
        child = doc.getLastChild();
        do {
            Truth.assertThat((Object)child).isNotInstanceOf(Text.class);
        } while ((child = child.getPreviousSibling()) != null);
        NodeList children = doc.getChildNodes();
        Truth.assertThat((Integer)children.getLength()).isEqualTo(2L);
        Truth.assertThat((Object)children.item(1)).isSameAs((Object)doc.getDocumentElement());
    }
}

