/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.ts.dom.DocumentBuilderFactoryFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DOMTestLoadException;
import org.w3c.domts.DocumentBuilderSetting;

final class DOMTestDocumentBuilderFactoryImpl
extends DOMTestDocumentBuilderFactory {
    private final DocumentBuilderFactoryFactory dbff;
    private final DocumentBuilderFactory dbf;
    private final DocumentBuilder builder;

    public DOMTestDocumentBuilderFactoryImpl(DocumentBuilderFactoryFactory dbff, DocumentBuilderSetting[] settings) throws DOMTestIncompatibleException {
        super(settings);
        this.dbff = dbff;
        this.dbf = dbff.newInstance();
        DocumentBuilderSetting[] documentBuilderSettingArray = settings;
        int n = settings.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentBuilderSetting setting = documentBuilderSettingArray[n2];
            setting.applySetting(this.dbf);
            ++n2;
        }
        try {
            this.builder = this.dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new DOMTestIncompatibleException(ex, null);
        }
    }

    public DOMTestDocumentBuilderFactory newInstance(DocumentBuilderSetting[] settings) throws DOMTestIncompatibleException {
        return new DOMTestDocumentBuilderFactoryImpl(this.dbff, this.mergeSettings(settings));
    }

    public DOMImplementation getDOMImplementation() {
        return this.builder.getDOMImplementation();
    }

    public boolean hasFeature(String feature, String version) {
        return this.builder.getDOMImplementation().hasFeature(feature, version);
    }

    public Document load(URL url) throws DOMTestLoadException {
        try {
            return this.builder.parse(url.openStream(), url.toString());
        }
        catch (Exception ex) {
            throw new DOMTestLoadException(ex);
        }
    }

    public boolean isCoalescing() {
        return this.dbf.isCoalescing();
    }

    public boolean isExpandEntityReferences() {
        return this.dbf.isExpandEntityReferences();
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.dbf.isIgnoringElementContentWhitespace();
    }

    public boolean isNamespaceAware() {
        return this.dbf.isNamespaceAware();
    }

    public boolean isValidating() {
        return this.dbf.isValidating();
    }
}

