/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts.level3.core;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMErrorMonitor;
import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestIncompatibleException;
import org.w3c.domts.DocumentBuilderSetting;

public final class documentnormalizedocument06
extends DOMTestCase {
    public documentnormalizedocument06(DOMTestDocumentBuilderFactory factory) throws DOMTestIncompatibleException {
        DocumentBuilderSetting[] settings = new DocumentBuilderSetting[]{DocumentBuilderSetting.namespaceAware};
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        this.setFactory(testFactory);
        String contentType = this.getContentType();
        this.preload(contentType, "barfoo", true);
    }

    public void runTest() throws Throwable {
        DOMErrorMonitor errorMonitor = new DOMErrorMonitor();
        List errors = new ArrayList();
        int splittedCount = 0;
        Document doc = this.load("barfoo", true);
        NodeList elemList = doc.getElementsByTagName("p");
        Element elem = (Element)elemList.item(0);
        CDATASection newChild = doc.createCDATASection("this is not ]]> good");
        Node oldChild = elem.getFirstChild();
        elem.replaceChild(newChild, oldChild);
        DOMConfiguration domConfig = doc.getDomConfig();
        domConfig.setParameter("split-cdata-sections", Boolean.TRUE);
        domConfig.setParameter("error-handler", errorMonitor);
        doc.normalizeDocument();
        newChild = (CDATASection)elem.getFirstChild();
        String nodeValue = newChild.getNodeValue();
        short nodeType = newChild.getNodeType();
        this.assertFalse("wasSplit", this.equals(4, nodeType) & nodeValue.indexOf("]]>") >= 0);
        errors = errorMonitor.getAllErrors();
        int indexN1010C = 0;
        while (indexN1010C < errors.size()) {
            DOMError error = (DOMError)errors.get(indexN1010C);
            String type = error.getType();
            short severity = error.getSeverity();
            if (this.equals("cdata-sections-splitted", type)) {
                Object relatedData = error.getRelatedData();
                this.assertSame("relatedData", newChild, relatedData);
                this.assertEquals("severity", 1, severity);
                String message = error.getMessage();
                int length = message.length();
                this.assertTrue("messageNotEmpty", length > 0);
                error.getRelatedException();
                DOMLocator location = error.getLocation();
                Node problemNode = location.getRelatedNode();
                this.assertSame("relatedNode", newChild, problemNode);
                location.getLineNumber();
                location.getColumnNumber();
                location.getByteOffset();
                location.getUtf16Offset();
                location.getUri();
                ++splittedCount;
            } else {
                this.assertEquals("anyOthersShouldBeWarnings", 1, severity);
            }
            ++indexN1010C;
        }
        this.assertEquals("oneSplittedWarning", 1, splittedCount);
    }

    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentnormalizedocument06";
    }

    public static void main(String[] args) {
        DOMTestCase.doMain(documentnormalizedocument06.class, args);
    }
}

