/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.domts;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.domts.DOMTest;
import org.w3c.domts.DOMTestDocumentBuilderFactory;
import org.w3c.domts.DOMTestFramework;

public abstract class DOMTestCase
extends DOMTest {
    private DOMTestFramework framework = null;

    public DOMTestCase() {
    }

    public DOMTestCase(DOMTestDocumentBuilderFactory factory) {
        super(factory);
    }

    public static void doMain(Class testClass, String[] args) {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> runnerClass = loader.loadClass("org.w3c.domts.JUnitRunner");
            Constructor<?> runnerFactory = runnerClass.getConstructor(Class.class);
            Object junitRun = runnerFactory.newInstance(testClass);
            Class<?> argsClass = loader.loadClass("[Ljava.lang.String;");
            Method execMethod = runnerClass.getMethod("execute", argsClass);
            execMethod.invoke(junitRun, new Object[]{args});
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
        }
        catch (Exception ex) {
            System.out.println("junit-run.jar and junit.jar \n must be in same directory or on classpath.");
            ex.printStackTrace();
        }
    }

    public abstract void runTest() throws Throwable;

    public void setFramework(DOMTestFramework framework) {
        this.framework = framework;
    }

    public void wait(int millisecond) {
        this.framework.wait(millisecond);
    }

    public void fail(String assertID) {
        this.framework.fail(this, assertID);
    }

    public void assertTrue(String assertID, boolean actual) {
        this.framework.assertTrue(this, assertID, actual);
    }

    public void assertTrue(String assertID, Object actual) {
        this.framework.assertTrue(this, assertID, (Boolean)actual);
    }

    public void assertFalse(String assertID, boolean actual) {
        this.framework.assertFalse(this, assertID, actual);
    }

    public void assertFalse(String assertID, Object actual) {
        this.framework.assertFalse(this, assertID, (Boolean)actual);
    }

    public void assertNull(String assertID, Object actual) {
        this.framework.assertNull(this, assertID, actual);
    }

    public void assertNotNull(String assertID, Object actual) {
        this.framework.assertNotNull(this, assertID, actual);
    }

    public void assertSame(String assertID, Object expected, Object actual) {
        this.framework.assertSame(this, assertID, expected, actual);
    }

    public void assertInstanceOf(String assertID, Class cls, Object obj) {
        this.framework.assertInstanceOf(this, assertID, obj, cls);
    }

    public void assertSize(String assertID, int expectedSize, NodeList collection) {
        this.framework.assertSize(this, assertID, expectedSize, collection);
    }

    public void assertSize(String assertID, int expectedSize, NamedNodeMap collection) {
        this.framework.assertSize(this, assertID, expectedSize, collection);
    }

    public void assertSize(String assertID, int expectedSize, Collection collection) {
        this.framework.assertSize(this, assertID, expectedSize, collection);
    }

    public void assertEqualsIgnoreCase(String assertID, String expected, String actual) {
        this.framework.assertEqualsIgnoreCase(this, assertID, expected, actual);
    }

    public void assertEqualsIgnoreCase(String assertID, Collection expected, Collection actual) {
        this.framework.assertEqualsIgnoreCase(this, assertID, expected, actual);
    }

    public void assertEqualsIgnoreCase(String assertID, List expected, List actual) {
        this.framework.assertEqualsIgnoreCase(this, assertID, expected, actual);
    }

    public void assertEqualsAutoCase(String context, String assertID, String expected, String actual) {
        String contentType = this.getContentType();
        if ("text/html".equals(contentType)) {
            if ("attribute".equals(context)) {
                this.framework.assertEqualsIgnoreCase(this, assertID, expected, actual);
            } else {
                this.framework.assertEquals(this, assertID, expected.toUpperCase(), actual);
            }
        } else {
            this.framework.assertEquals(this, assertID, expected, actual);
        }
    }

    private List toUpperCase(Collection expected) {
        ArrayList<String> upperd = new ArrayList<String>(expected.size());
        Iterator iter = expected.iterator();
        while (iter.hasNext()) {
            upperd.add(iter.next().toString().toUpperCase());
        }
        return upperd;
    }

    public void assertEqualAutoCase(String context, String assertID, Collection expected, Collection actual) {
        String contentType = this.getContentType();
        if ("text/html".equals(contentType)) {
            if ("attribute".equals(context)) {
                this.assertEqualsIgnoreCase(assertID, expected, actual);
            } else {
                this.framework.assertEquals(this, assertID, this.toUpperCase(expected), actual);
            }
        } else {
            this.framework.assertEquals(this, assertID, expected, actual);
        }
    }

    public void assertEqualsAutoCase(String context, String assertID, List expected, List actual) {
        String contentType = this.getContentType();
        if ("text/html".equals(contentType)) {
            if ("attribute".equals(context)) {
                this.assertEqualsIgnoreCase(assertID, expected, actual);
            } else {
                this.framework.assertEquals(this, assertID, this.toUpperCase(expected), actual);
            }
        } else {
            this.framework.assertEquals(this, assertID, expected, actual);
        }
    }

    public void assertEquals(String assertID, String expected, String actual) {
        this.framework.assertEquals(this, assertID, expected, actual);
    }

    public void assertEquals(String assertID, int expected, int actual) {
        this.framework.assertEquals(this, assertID, expected, actual);
    }

    public void assertEquals(String assertID, double expected, double actual) {
        this.framework.assertEquals(this, assertID, expected, actual);
    }

    public void assertEquals(String assertID, boolean expected, boolean actual) {
        this.framework.assertEquals(this, assertID, expected, actual);
    }

    public void assertEquals(String assertID, Collection expected, NodeList actual) {
        ArrayList<Node> actualList = new ArrayList<Node>();
        int actualLen = actual.getLength();
        int i = 0;
        while (i < actualLen) {
            actualList.add(actual.item(i));
            ++i;
        }
        this.framework.assertEquals(this, assertID, expected, actualList);
    }

    public void assertEquals(String assertID, Collection expected, Collection actual) {
        this.framework.assertEquals(this, assertID, expected, actual);
    }

    public void assertNotEqualsIgnoreCase(String assertID, String expected, String actual) {
        this.framework.assertNotEqualsIgnoreCase(this, assertID, expected, actual);
    }

    public void assertNotEqualsAutoCase(String context, String assertID, String expected, String actual) {
        String contentType = this.getContentType();
        if ("text/html".equals(contentType)) {
            if ("attribute".equals(context)) {
                this.framework.assertNotEqualsIgnoreCase(this, assertID, expected, actual);
            } else {
                this.framework.assertNotEquals(this, assertID, expected.toUpperCase(), actual);
            }
        }
        this.framework.assertNotEquals(this, assertID, expected, actual);
    }

    public void assertNotEquals(String assertID, String expected, String actual) {
        this.framework.assertNotEquals(this, assertID, expected, actual);
    }

    public void assertNotEquals(String assertID, int expected, int actual) {
        this.framework.assertNotEquals(this, assertID, expected, actual);
    }

    public void assertNotEquals(String assertID, double expected, double actual) {
        this.framework.assertNotEquals(this, assertID, expected, actual);
    }

    public void assertURIEquals(String assertID, String scheme, String path, String host, String file, String name, String query, String fragment, Boolean isAbsolute, String actual) {
        this.assertNotNull(assertID, actual);
        String uri = actual;
        int lastPound = actual.lastIndexOf("#");
        String actualFragment = "";
        if (lastPound != -1) {
            uri = actual.substring(0, lastPound);
            actualFragment = actual.substring(lastPound + 1);
        }
        if (fragment != null) {
            this.assertEquals(assertID, fragment, actualFragment);
        }
        int lastQuestion = uri.lastIndexOf("?");
        String actualQuery = "";
        if (lastQuestion != -1) {
            uri = actual.substring(0, lastQuestion);
            actualQuery = actual.substring(lastQuestion + 1);
        }
        if (query != null) {
            this.assertEquals(assertID, query, actualQuery);
        }
        int firstColon = uri.indexOf(":");
        int firstSlash = uri.indexOf("/");
        String actualPath = uri;
        String actualScheme = "";
        if (firstColon != -1 && firstColon < firstSlash) {
            actualScheme = uri.substring(0, firstColon);
            actualPath = uri.substring(firstColon + 1);
        }
        if (scheme != null) {
            this.assertEquals(assertID, scheme, actualScheme);
        }
        if (path != null) {
            this.assertEquals(assertID, path, actualPath);
        }
        if (host != null) {
            String actualHost = "";
            if (actualPath.startsWith("//")) {
                int termSlash = actualPath.indexOf("/", 2);
                actualHost = actualPath.substring(0, termSlash);
            }
            this.assertEquals(assertID, host, actualHost);
        }
        String actualFile = actualPath;
        if (file != null || name != null) {
            int finalSlash = actualPath.lastIndexOf("/");
            if (finalSlash != -1) {
                actualFile = actualPath.substring(finalSlash + 1);
            }
            if (file != null) {
                this.assertEquals(assertID, file, actualFile);
            }
        }
        if (name != null) {
            String actualName = actualFile;
            int finalPeriod = actualFile.lastIndexOf(".");
            if (finalPeriod != -1) {
                actualName = actualFile.substring(0, finalPeriod);
            }
            this.assertEquals(assertID, name, actualName);
        }
        if (isAbsolute != null) {
            this.assertEquals(assertID, isAbsolute, actualPath.startsWith("/") || actualPath.startsWith("file:/"));
        }
    }

    public boolean same(Object expected, Object actual) {
        return this.framework.same(expected, actual);
    }

    public boolean equalsIgnoreCase(String expected, String actual) {
        return this.framework.equalsIgnoreCase(expected, actual);
    }

    public boolean equalsIgnoreCase(Collection expected, Collection actual) {
        return this.framework.equalsIgnoreCase(expected, actual);
    }

    public boolean equalsIgnoreCase(List expected, List actual) {
        return this.framework.equalsIgnoreCase(expected, actual);
    }

    public boolean equalsAutoCase(String context, String expected, String actual) {
        if ("text/html".equals(this.getContentType())) {
            if ("attribute".equals(context)) {
                return this.framework.equalsIgnoreCase(expected, actual);
            }
            return this.framework.equals(expected.toUpperCase(), actual);
        }
        return this.framework.equals(expected, actual);
    }

    public boolean equalsAutoCase(String context, Collection expected, Collection actual) {
        if ("text/html".equals(this.getContentType())) {
            if ("attribute".equals(context)) {
                return this.framework.equalsIgnoreCase(expected, actual);
            }
            return this.framework.equals((Collection)this.toUpperCase(expected), actual);
        }
        return this.framework.equals(expected, actual);
    }

    public boolean equalsAutoCase(String context, List expected, List actual) {
        if ("text/html".equals(this.getContentType())) {
            if ("attribute".equals(context)) {
                return this.framework.equalsIgnoreCase(expected, actual);
            }
            return this.framework.equals(this.toUpperCase(expected), actual);
        }
        return this.framework.equals(expected, actual);
    }

    public boolean equals(String expected, String actual) {
        return this.framework.equals(expected, actual);
    }

    public boolean equals(int expected, int actual) {
        return this.framework.equals(expected, actual);
    }

    public boolean equals(double expected, double actual) {
        return this.framework.equals(expected, actual);
    }

    public boolean equals(Collection expected, Collection actual) {
        return this.framework.equals(expected, actual);
    }

    public boolean equals(List expected, List actual) {
        return this.framework.equals(expected, actual);
    }

    public int size(Collection collection) {
        return this.framework.size(collection);
    }

    public int size(NamedNodeMap collection) {
        return this.framework.size(collection);
    }

    public int size(NodeList collection) {
        return this.framework.size(collection);
    }
}

