/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.document;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.testutils.suite.XSLTImplementation;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.dom.document.TransformerTestCase;
import org.w3c.dom.Document;

public class TestTransformerWithStylesheet
extends TransformerTestCase {
    public TestTransformerWithStylesheet(DocumentBuilderFactory dbf, XSLTImplementation xsltImplementation) {
        super(dbf, xsltImplementation);
    }

    protected void runTest() throws Throwable {
        DocumentBuilder builder = this.dbf.newDocumentBuilder();
        Document input = builder.parse(TestTransformerWithStylesheet.class.getResourceAsStream("input.xml"));
        Document stylesheet = builder.parse(TestTransformerWithStylesheet.class.getResourceAsStream("stylesheet.xslt"));
        Document expected = builder.parse(TestTransformerWithStylesheet.class.getResourceAsStream("output.xml"));
        Document actual = builder.newDocument();
        Transformer transformer = this.xsltImplementation.newTransformerFactory().newTransformer(new DOMSource(stylesheet));
        transformer.transform(new DOMSource(input), new DOMResult(actual));
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that(XMLTruth.xml(Document.class, (Object)actual))).ignoringWhitespace().hasSameContentAs(XMLTruth.xml(Document.class, (Object)expected));
    }
}

