/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.document;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.testutils.suite.XSLTImplementation;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.dom.document.TransformerTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestTransformerWithIdentityStylesheet
extends TransformerTestCase {
    public TestTransformerWithIdentityStylesheet(DocumentBuilderFactory dbf, XSLTImplementation xsltImplementation) {
        super(dbf, xsltImplementation);
    }

    protected void runTest() throws Throwable {
        DocumentBuilder builder = this.dbf.newDocumentBuilder();
        Document document = builder.newDocument();
        Element root = document.createElementNS("", "root");
        Element element = document.createElementNS("urn:mynamespace", "element1");
        element.setAttribute("att", "testValue");
        element.appendChild(document.createTextNode("test"));
        root.appendChild(element);
        document.appendChild(root);
        Document stylesheet = builder.parse(TestTransformerWithIdentityStylesheet.class.getResourceAsStream("identity.xslt"));
        Document output = builder.newDocument();
        Transformer transformer = this.xsltImplementation.newTransformerFactory().newTransformer(new DOMSource(stylesheet));
        transformer.transform(new DOMSource(document), new DOMResult(output));
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that(XMLTruth.xml(Document.class, (Object)output))).ignoringNamespaceDeclarations().hasSameContentAs(XMLTruth.xml(Document.class, (Object)document));
    }
}

