/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dom.builder;

import com.google.common.truth.Truth;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.testutils.activation.InstrumentedDataSource;
import org.apache.axiom.testutils.net.protocol.mem.DataSourceRegistration;
import org.apache.axiom.testutils.net.protocol.mem.DataSourceRegistry;
import org.apache.axiom.ts.dom.DOMTestCase;
import org.apache.axiom.ts.xml.XMLSample;
import org.w3c.dom.Document;

public class TestParseURI
extends DOMTestCase {
    public TestParseURI(DocumentBuilderFactory dbf) {
        super(dbf);
    }

    protected void runTest() throws Throwable {
        InstrumentedDataSource ds = new InstrumentedDataSource((DataSource)new URLDataSource(XMLSample.SIMPLE.getUrl()));
        DataSourceRegistration registration = DataSourceRegistry.registerDataSource((DataSource)ds);
        try {
            DocumentBuilder builder = this.dbf.newDocumentBuilder();
            Document document = builder.parse(registration.getURL().toExternalForm());
            Truth.assertThat((String)document.getDocumentElement().getLocalName()).isEqualTo((Object)"root");
            Truth.assertThat((Integer)ds.getOpenStreamCount()).isEqualTo(0L);
        }
        finally {
            registration.unregister();
        }
    }
}

