/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.buildutils.pom;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="create-dependency-reduced-pom", defaultPhase=LifecyclePhase.PACKAGE)
public class CreateDependencyReducedPomMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private Set<String> excludedArtifacts;
    @Parameter(defaultValue="${project.build.directory}/dependency-reduced-pom.xml")
    private File dependencyReducedPomLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Model model;
        if (this.excludedArtifacts == null || this.excludedArtifacts.isEmpty()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(this.project.getFile());){
            model = new MavenXpp3Reader().read((InputStream)in);
        }
        catch (IOException | XmlPullParserException ex) {
            throw new MojoExecutionException("Error reading POM", (Exception)ex);
        }
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            Dependency dependency = (Dependency)it.next();
            if (!this.excludedArtifacts.contains(dependency.getArtifactId())) continue;
            it.remove();
        }
        this.dependencyReducedPomLocation.getParentFile().mkdirs();
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        try (FileOutputStream out = new FileOutputStream(this.dependencyReducedPomLocation);){
            pomWriter.write((OutputStream)out, model);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error writing dependency-reduced POM", (Exception)ex);
        }
        this.project.setPomFile(this.dependencyReducedPomLocation);
    }
}

