/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.testutils.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.ext.io.StreamCopyException;

public class TestBlob
implements Blob {
    final int value;
    final long length;

    public TestBlob(int value, long length) {
        this.value = value;
        this.length = length;
    }

    public InputStream getInputStream() throws IOException {
        return new InputStream(){
            private long position;

            @Override
            public int read() throws IOException {
                if (this.position == TestBlob.this.length) {
                    return -1;
                }
                ++this.position;
                return TestBlob.this.value;
            }
        };
    }

    public void writeTo(OutputStream out) throws StreamCopyException {
        for (long i = 0L; i < this.length; ++i) {
            try {
                out.write(this.value);
                continue;
            }
            catch (IOException ex) {
                throw new StreamCopyException(2, ex);
            }
        }
    }

    public long getSize() {
        return this.length;
    }
}

