/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soapdom.header;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestExamineMustUnderstandHeaderBlocks
extends SOAPTestCase {
    public TestExamineMustUnderstandHeaderBlocks(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        int i;
        SOAPHeader header = this.soapFactory.createSOAPHeader();
        Element domHeader = (Element)header;
        Document document = domHeader.getOwnerDocument();
        Element[] headerBlocks = new Element[3];
        for (i = 0; i < 3; ++i) {
            headerBlocks[i] = document.createElementNS("urn:test", "p:h" + i);
        }
        headerBlocks[1].setAttributeNS(this.spec.getEnvelopeNamespaceURI(), "S:mustUnderstand", "1");
        for (i = 0; i < 3; ++i) {
            domHeader.appendChild(headerBlocks[i].cloneNode(true));
        }
        Iterator it = header.examineMustUnderstandHeaderBlocks(null);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)it.next();
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMElement.class, (Object)headerBlock))).hasSameContentAs(XMLTruth.xml(Element.class, (Object)headerBlocks[1]));
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

