/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soapdom.header;

import com.google.common.truth.Truth;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestExamineAllHeaderBlocks
extends SOAPTestCase {
    public TestExamineAllHeaderBlocks(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPHeader header = this.soapFactory.createSOAPHeader();
        Element domHeader = (Element)header;
        Document document = domHeader.getOwnerDocument();
        Element headerBlock1 = document.createElementNS("urn:test", "p:h1");
        headerBlock1.setAttributeNS(this.spec.getEnvelopeNamespaceURI(), "S:mustUnderstand", "1");
        headerBlock1.setTextContent("test");
        Element headerBlock2 = document.createElementNS("urn:test", "p:h2");
        headerBlock2.appendChild(document.createElementNS(null, "test"));
        domHeader.appendChild(headerBlock1);
        domHeader.appendChild(headerBlock2);
        Iterator it = header.examineAllHeaderBlocks();
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)it.next();
        Truth.assertThat((Object)headerBlock.getQName()).isEqualTo((Object)new QName("urn:test", "h1"));
        Truth.assertThat((Boolean)headerBlock.getMustUnderstand()).isTrue();
        Truth.assertThat((String)headerBlock.getText()).isEqualTo((Object)"test");
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        headerBlock = (SOAPHeaderBlock)it.next();
        Truth.assertThat((Object)headerBlock.getQName()).isEqualTo((Object)new QName("urn:test", "h2"));
        Truth.assertThat((Object)headerBlock.getFirstOMChild()).isInstanceOf(OMElement.class);
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

