/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.mtom;

import com.google.common.truth.Truth;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.XOPEncoded;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.MTOMSample;

public class TestGetXMLStreamReaderMTOMEncoded
extends AxiomTestCase {
    private static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    private final boolean cache;

    public TestGetXMLStreamReaderMTOMEncoded(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestParameter("cache", cache);
    }

    protected void runTest() throws Throwable {
        InputStream inStream = MTOMSample.SAMPLE2.getInputStream();
        MultipartBody mb = MultipartBody.builder().setInputStream(inStream).setContentType(MTOMSample.SAMPLE2.getContentType()).build();
        OMElement root = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (MultipartBody)mb).getDocumentElement();
        XOPEncoded xopEncodedStream = root.getXOPEncodedStreamReader(this.cache);
        XMLStreamReader xmlStreamReader = (XMLStreamReader)xopEncodedStream.getRootPart();
        Blob blob = null;
        while (xmlStreamReader.hasNext() && blob == null) {
            QName qName;
            xmlStreamReader.next();
            if (!xmlStreamReader.isStartElement() || !XOP_INCLUDE.equals(qName = xmlStreamReader.getName())) continue;
            String hrefValue = xmlStreamReader.getAttributeValue("", "href");
            Truth.assertThat((String)hrefValue).startsWith("cid:");
            if (hrefValue == null) continue;
            blob = xopEncodedStream.getAttachmentAccessor().getBlob(hrefValue.substring(4));
        }
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((blob != null ? 1 : 0) != 0);
        xmlStreamReader.next();
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)xmlStreamReader.isEndElement());
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)XOP_INCLUDE.equals(xmlStreamReader.getName()));
        xmlStreamReader.next();
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)xmlStreamReader.isEndElement());
        TestGetXMLStreamReaderMTOMEncoded.assertTrue((boolean)"name".equals(xmlStreamReader.getLocalName()));
    }
}

