/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.envelope;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Iterator;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.mime.PartBlob;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.testutils.blob.TestBlob;
import org.apache.axiom.testutils.io.IOTestUtils;
import org.apache.axiom.ts.AxiomTestCase;

public class TestMTOMForwardStreaming
extends AxiomTestCase {
    private final boolean buildSOAPPart;

    public TestMTOMForwardStreaming(OMMetaFactory metaFactory, boolean buildSOAPPart) {
        super(metaFactory);
        this.addTestParameter("buildSOAPPart", buildSOAPPart);
        this.buildSOAPPart = buildSOAPPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        TestBlob blob1 = new TestBlob(65, Runtime.getRuntime().maxMemory());
        TestBlob blob2 = new TestBlob(66, Runtime.getRuntime().maxMemory());
        SOAPFactory factory = this.metaFactory.getSOAP12Factory();
        SOAPEnvelope orgEnvelope = factory.createSOAPEnvelope();
        SOAPBody orgBody = factory.createSOAPBody(orgEnvelope);
        OMElement orgBodyElement = factory.createOMElement("test", factory.createOMNamespace("urn:test", "p"), (OMContainer)orgBody);
        OMElement orgData1 = factory.createOMElement("data", null, (OMContainer)orgBodyElement);
        orgData1.addChild((OMNode)factory.createOMText((Blob)blob1, true));
        OMElement orgData2 = factory.createOMElement("data", null, (OMContainer)orgBodyElement);
        orgData2.addChild((OMNode)factory.createOMText((Blob)blob2, true));
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setSOAP11(false);
        String contentType = format.getContentType();
        PipedOutputStream pipe1Out = new PipedOutputStream();
        PipedInputStream pipe1In = new PipedInputStream(pipe1Out);
        Thread producerThread = new Thread(() -> {
            try {
                try {
                    orgEnvelope.serialize((OutputStream)pipe1Out, format);
                }
                finally {
                    pipe1Out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        producerThread.start();
        PipedOutputStream pipe2Out = new PipedOutputStream();
        PipedInputStream pipe2In = new PipedInputStream(pipe2Out);
        Thread forwarderThread = new Thread(() -> {
            try {
                try {
                    MultipartBody mb = MultipartBody.builder().setInputStream((InputStream)pipe1In).setContentType(contentType).build();
                    SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (MultipartBody)mb).getSOAPEnvelope();
                    if (this.buildSOAPPart) {
                        envelope.build();
                    }
                    envelope.serializeAndConsume((OutputStream)pipe2Out, format);
                }
                finally {
                    pipe2Out.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        forwarderThread.start();
        try {
            MultipartBody mb = MultipartBody.builder().setInputStream((InputStream)pipe2In).setContentType(contentType).build();
            SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (MultipartBody)mb).getSOAPEnvelope();
            OMElement bodyElement = envelope.getBody().getFirstElement();
            Iterator it = bodyElement.getChildElements();
            OMElement data1 = (OMElement)it.next();
            OMElement data2 = (OMElement)it.next();
            IOTestUtils.compareStreams((InputStream)blob1.getInputStream(), (InputStream)((PartBlob)((OMText)data1.getFirstOMChild()).getBlob()).getPart().getInputStream(false));
            IOTestUtils.compareStreams((InputStream)blob2.getInputStream(), (InputStream)((PartBlob)((OMText)data2.getFirstOMChild()).getBlob()).getPart().getInputStream(false));
        }
        finally {
            pipe2In.close();
        }
    }
}

