/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.ts.AxiomTestCase;

public class TestBuilder
extends AxiomTestCase {
    public TestBuilder(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        String soap12Message = "<env:Envelope xmlns:env=\"http://www.w3.org/2003/05/soap-envelope\">\n   <env:Header>\n       <test:echoOk xmlns:test=\"http://example.org/ts-tests\"\n                    env:role=\"http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver\"\n                    env:mustUnderstand=\"true\">\n                       foo\n       </test:echoOk>\n   </env:Header>\n   <env:Body>\n       <env:Fault>\n           <env:Code>\n               <env:Value>env:Sender</env:Value>\n               <env:Subcode>\n                   <env:Value>m:MessageTimeout</env:Value>\n                   <env:Subcode>\n                       <env:Value>m:MessageTimeout</env:Value>\n                   </env:Subcode>\n               </env:Subcode>\n           </env:Code>\n           <env:Reason>\n               <env:Text>Sender Timeout</env:Text>\n           </env:Reason>\n           <env:Node>\n               http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver\n           </env:Node>\n           <env:Role>\n               ultimateReceiver\n           </env:Role>\n           <env:Detail xmlns:m=\"http:www.sample.org\">\n               Details of error\n               <m:MaxTime m:detail=\"This is only a test\">\n                   P5M\n               </m:MaxTime>\n               <m:AveTime>\n                   <m:Time>\n                       P3M\n                   </m:Time>\n               </m:AveTime>\n           </env:Detail>\n       </env:Fault>\n   </env:Body>\n</env:Envelope>";
        SOAPModelBuilder soap12Builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Reader)new StringReader(soap12Message));
        SOAPEnvelope soap12Envelope = (SOAPEnvelope)soap12Builder.getDocumentElement();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- envelope local name mismatch", (boolean)soap12Envelope.getLocalName().equals("Envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- envelope namespace uri mismatch", (boolean)soap12Envelope.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        SOAPHeader header = soap12Envelope.getHeader();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Header local name mismatch", (boolean)header.getLocalName().equals("Header"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Header namespace uri mismatch", (boolean)header.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)header.getFirstElement();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Header block name mismatch", (boolean)headerBlock.getLocalName().equals("echoOk"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Header block name space uri mismatch", (boolean)headerBlock.getNamespace().getNamespaceURI().equals("http://example.org/ts-tests"));
        TestBuilder.assertEquals((String)"SOAP 1.2 :- Header block text mismatch", (String)headerBlock.getText().trim(), (String)"foo");
        QName roleQName = new QName("http://www.w3.org/2003/05/soap-envelope", "role");
        QName mustUnderstandQName = new QName("http://www.w3.org/2003/05/soap-envelope", "mustUnderstand");
        OMAttribute roleAttribute = headerBlock.getAttribute(roleQName);
        OMAttribute mustUnderstandAttribute = headerBlock.getAttribute(mustUnderstandQName);
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Role attribute name not found", (roleAttribute != null ? 1 : 0) != 0);
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Role value mismatch", (boolean)roleAttribute.getAttributeValue().trim().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Mustunderstand attribute not found", (mustUnderstandAttribute != null ? 1 : 0) != 0);
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Mustunderstand value mismatch", (boolean)mustUnderstandAttribute.getAttributeValue().equals("true"));
        SOAPBody body = soap12Envelope.getBody();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Body local name mismatch", (boolean)body.getLocalName().equals("Body"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Body namespace uri mismatch", (boolean)body.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        SOAPFault fault = body.getFault();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault local name mismatch", (boolean)fault.getLocalName().equals("Fault"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault namespace uri mismatch", (boolean)fault.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        Iterator iteratorInFault = fault.getChildren();
        iteratorInFault.next();
        SOAPFaultCode code = (SOAPFaultCode)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code local name mismatch", (boolean)code.getLocalName().equals("Code"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code namespace uri mismatch", (boolean)code.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        Iterator iteratorInCode = code.getChildren();
        iteratorInCode.next();
        SOAPFaultValue value1 = (SOAPFaultValue)iteratorInCode.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code value local name mismatch", (boolean)value1.getLocalName().equals("Value"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code namespace uri mismatch", (boolean)value1.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Value1 text mismatch", (boolean)value1.getText().equals("env:Sender"));
        QName valueQName = value1.getTextAsQName();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code value's qname local name mismatch", (boolean)valueQName.getLocalPart().equals("Sender"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code value's qname namespace uri mismatch", (boolean)valueQName.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        iteratorInCode.next();
        SOAPFaultSubCode subCode1 = (SOAPFaultSubCode)iteratorInCode.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault sub code local name mismatch", (boolean)subCode1.getLocalName().equals("Subcode"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault subcode namespace uri mismatch", (boolean)subCode1.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        Iterator iteratorInSubCode1 = subCode1.getChildren();
        iteratorInSubCode1.next();
        SOAPFaultValue value2 = (SOAPFaultValue)iteratorInSubCode1.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code value local name mismatch", (boolean)value2.getLocalName().equals("Value"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code namespace uri mismatch", (boolean)value2.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Value2 text mismatch", (boolean)value2.getText().equals("m:MessageTimeout"));
        iteratorInSubCode1.next();
        SOAPFaultSubCode subCode2 = (SOAPFaultSubCode)iteratorInSubCode1.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault sub code local name mismatch", (boolean)subCode2.getLocalName().equals("Subcode"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault subcode namespace uri mismatch", (boolean)subCode2.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        Iterator iteratorInSubCode2 = subCode2.getChildren();
        iteratorInSubCode2.next();
        SOAPFaultValue value3 = (SOAPFaultValue)iteratorInSubCode2.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code value local name mismatch", (boolean)value3.getLocalName().equals("Value"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault code namespace uri mismatch", (boolean)value3.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Value2 text mismatch", (boolean)value3.getText().equals("m:MessageTimeout"));
        iteratorInFault.next();
        SOAPFaultReason reason = (SOAPFaultReason)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault reason local name mismatch", (boolean)reason.getLocalName().equals("Reason"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault reason namespace uri mismatch", (boolean)reason.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        Iterator iteratorInReason = reason.getChildren();
        iteratorInReason.next();
        SOAPFaultText text = (SOAPFaultText)iteratorInReason.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault text local name mismatch", (boolean)text.getLocalName().equals("Text"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text namespace uri mismatch", (boolean)text.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text value mismatch", (boolean)text.getText().equals("Sender Timeout"));
        iteratorInFault.next();
        SOAPFaultNode node = (SOAPFaultNode)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault node local name mismatch", (boolean)node.getLocalName().equals("Node"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault node namespace uri mismatch", (boolean)node.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Node value mismatch", (boolean)node.getText().trim().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        iteratorInFault.next();
        SOAPFaultRole role = (SOAPFaultRole)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault role local name mismatch", (boolean)role.getLocalName().equals("Role"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault role namespace uri mismatch", (boolean)role.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Role value mismatch", (boolean)role.getText().trim().equals("ultimateReceiver"));
        iteratorInFault.next();
        SOAPFaultDetail detail = (SOAPFaultDetail)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault detail local name mismatch", (boolean)detail.getLocalName().equals("Detail"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Fault detail namespace uri mismatch", (boolean)detail.getNamespace().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text in detail mismatch", (boolean)detail.getText().trim().equals("Details of error"));
        Iterator iteratorInDetail = detail.getChildren();
        iteratorInDetail.next();
        OMElement element1 = (OMElement)iteratorInDetail.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- MaxTime element mismatch", (boolean)element1.getLocalName().equals("MaxTime"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- MaxTime element namespace mismatch", (boolean)element1.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text value in MaxTime element mismatch", (boolean)element1.getText().trim().equals("P5M"));
        Iterator attributeIterator = element1.getAllAttributes();
        OMAttribute attributeInMaxTime = (OMAttribute)attributeIterator.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Attribute local name mismatch", (boolean)attributeInMaxTime.getLocalName().equals("detail"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Attribute namespace mismatch", (boolean)attributeInMaxTime.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Attribute value mismatch", (boolean)attributeInMaxTime.getAttributeValue().trim().equals("This is only a test"));
        iteratorInDetail.next();
        OMElement element2 = (OMElement)iteratorInDetail.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- AveTime element mismatch", (boolean)element2.getLocalName().equals("AveTime"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- AveTime element namespace mismatch", (boolean)element2.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        Iterator iteratorInAveTimeElement = element2.getChildren();
        iteratorInAveTimeElement.next();
        OMElement element21 = (OMElement)iteratorInAveTimeElement.next();
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Time element mismatch", (boolean)element21.getLocalName().equals("Time"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Time element namespace mismatch", (boolean)element21.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text value in Time element mismatch", (boolean)element21.getText().trim().equals("P3M"));
        soap12Builder.close();
    }
}

