/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap11.builder;

import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.ts.AxiomTestCase;

public class TestBuilder
extends AxiomTestCase {
    public TestBuilder(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        String soap11Message = "<?xml version='1.0' ?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\">\n   <env:Header>\n       <test:echoOk xmlns:test=\"http://example.org/ts-tests\"\n                    env:actor=\"http://schemas.xmlsoap.org/soap/actor/next\"\n                    env:mustUnderstand=\"1\"       >\n                       foo\n       </test:echoOk>\n   </env:Header>\n   <env:Body>\n       <env:Fault>\n           <faultcode>\n               env:Sender\n           </faultcode>\n           <faultstring>\n               Sender Timeout\n           </faultstring>\n           <faultactor>\n               http://schemas.xmlsoap.org/soap/envelope/actor/ultimateReceiver\n           </faultactor>\n           <detail xmlns:m=\"http:www.sample.org\">\n               Details of error\n               <m:MaxTime m:detail=\"This is only a test\">\n                   P5M\n               </m:MaxTime>\n               <m:AveTime>\n                   <m:Time>\n                       P3M\n                   </m:Time>\n               </m:AveTime>\n           </detail>\n           <n:Test xmlns:n=\"http:www.Test.org\">\n               <n:TestElement>\n                   This is only a test\n               </n:TestElement>\n           </n:Test>\n       </env:Fault>\n   </env:Body>\n</env:Envelope>";
        SOAPModelBuilder soap11Builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Reader)new StringReader(soap11Message));
        SOAPEnvelope soap11Envelope = (SOAPEnvelope)soap11Builder.getDocumentElement();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- envelope local name mismatch", (boolean)soap11Envelope.getLocalName().equals("Envelope"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- envelope namespace uri mismatch", (boolean)soap11Envelope.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        SOAPHeader header = soap11Envelope.getHeader();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Header local name mismatch", (boolean)header.getLocalName().equals("Header"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Header namespace uri mismatch", (boolean)header.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)header.getFirstElement();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Header block name mismatch", (boolean)headerBlock.getLocalName().equals("echoOk"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Header block name space uri mismatch", (boolean)headerBlock.getNamespace().getNamespaceURI().equals("http://example.org/ts-tests"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Headaer block text mismatch", (boolean)headerBlock.getText().trim().equals("foo"));
        QName actorQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "actor");
        QName mustUnderstandQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
        OMAttribute actorAttribute = headerBlock.getAttribute(actorQName);
        OMAttribute mustUnderstandAttribute = headerBlock.getAttribute(mustUnderstandQName);
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Mustunderstand attribute not found", (mustUnderstandAttribute != null ? 1 : 0) != 0);
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Mustunderstand value mismatch", (boolean)mustUnderstandAttribute.getAttributeValue().equals("1"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Mustunderstand attribute namespace uri mismatch", (boolean)mustUnderstandAttribute.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Actor attribute name not found", (actorAttribute != null ? 1 : 0) != 0);
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Actor value mismatch", (boolean)actorAttribute.getAttributeValue().trim().equals("http://schemas.xmlsoap.org/soap/actor/next"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Actor attribute namespace uri mismatch", (boolean)actorAttribute.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        SOAPBody body = soap11Envelope.getBody();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Body local name mismatch", (boolean)body.getLocalName().equals("Body"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Body namespace uri mismatch", (boolean)body.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        SOAPFault fault = body.getFault();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Fault namespace uri mismatch", (boolean)fault.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/"));
        Iterator iteratorInFault = fault.getChildren();
        iteratorInFault.next();
        SOAPFaultCode code = (SOAPFaultCode)iteratorInFault.next();
        TestBuilder.assertEquals((String)"SOAP Fault code local name mismatch", (String)code.getLocalName(), (String)"faultcode");
        TestBuilder.assertEquals((String)"SOAP 1.1 :- Fault code value mismatch", (String)code.getText().trim(), (String)"env:Sender");
        iteratorInFault.next();
        SOAPFaultReason reason = (SOAPFaultReason)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Fault string local name mismatch", (boolean)reason.getLocalName().equals("faultstring"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Fault string value mismatch", (boolean)reason.getText().trim().equals("Sender Timeout"));
        iteratorInFault.next();
        SOAPFaultRole role = (SOAPFaultRole)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Fault actor local name mismatch", (boolean)role.getLocalName().equals("faultactor"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Actor value mismatch", (boolean)role.getText().trim().equals("http://schemas.xmlsoap.org/soap/envelope/actor/ultimateReceiver"));
        iteratorInFault.next();
        SOAPFaultDetail detail = (SOAPFaultDetail)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Fault detail local name mismatch", (boolean)detail.getLocalName().equals("detail"));
        TestBuilder.assertTrue((String)"SOAP 1.2 :- Text in detail mismatch", (boolean)detail.getText().trim().equals("Details of error"));
        Iterator iteratorInDetail = detail.getChildren();
        iteratorInDetail.next();
        OMElement element1 = (OMElement)iteratorInDetail.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- MaxTime element mismatch", (boolean)element1.getLocalName().equals("MaxTime"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- MaxTime element namespace mismatch", (boolean)element1.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Text value in MaxTime element mismatch", (boolean)element1.getText().trim().equals("P5M"));
        Iterator attributeIterator = element1.getAllAttributes();
        OMAttribute attributeInMaxTime = (OMAttribute)attributeIterator.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Attribute local name mismatch", (boolean)attributeInMaxTime.getLocalName().equals("detail"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Attribute namespace mismatch", (boolean)attributeInMaxTime.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Attribute value mismatch", (boolean)attributeInMaxTime.getAttributeValue().equals("This is only a test"));
        iteratorInDetail.next();
        OMElement element2 = (OMElement)iteratorInDetail.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- AveTime element mismatch", (boolean)element2.getLocalName().equals("AveTime"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- AveTime element namespace mismatch", (boolean)element2.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        Iterator iteratorInAveTimeElement = element2.getChildren();
        iteratorInAveTimeElement.next();
        OMElement element21 = (OMElement)iteratorInAveTimeElement.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Time element mismatch", (boolean)element21.getLocalName().equals("Time"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Time element namespace mismatch", (boolean)element21.getNamespace().getNamespaceURI().equals("http:www.sample.org"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Text value in Time element mismatch", (boolean)element21.getText().trim().equals("P3M"));
        iteratorInFault.next();
        OMElement testElement = (OMElement)iteratorInFault.next();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Test element mismatch", (boolean)testElement.getLocalName().equals("Test"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Test element namespace mismatch", (boolean)testElement.getNamespace().getNamespaceURI().equals("http:www.Test.org"));
        OMElement childOfTestElement = testElement.getFirstElement();
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Test element child local name mismatch", (boolean)childOfTestElement.getLocalName().equals("TestElement"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Test element child namespace mismatch", (boolean)childOfTestElement.getNamespace().getNamespaceURI().equals("http:www.Test.org"));
        TestBuilder.assertTrue((String)"SOAP 1.1 :- Test element child value mismatch", (boolean)childOfTestElement.getText().trim().equals("This is only a test"));
        soap11Builder.close();
    }
}

