/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.xpath;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestXPathAppliedToSOAPEnvelope
extends SOAPTestCase {
    private boolean createDocument;

    public TestXPathAppliedToSOAPEnvelope(OMMetaFactory metaFactory, SOAPSpec spec, boolean createDocument) {
        super(metaFactory, spec);
        this.createDocument = createDocument;
        this.addTestParameter("createDocument", createDocument);
    }

    protected void runTest() throws Throwable {
        OMElement elem1 = this.soapFactory.createOMElement("elem1", null);
        OMElement elem2 = this.soapFactory.createOMElement("elem2", null);
        OMElement elem3 = this.soapFactory.createOMElement("elem3", null);
        elem2.addChild((OMNode)elem3);
        elem1.addChild((OMNode)elem2);
        SOAPEnvelope envelope = this.soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)elem1);
        if (this.createDocument) {
            this.soapFactory.createOMDocument().addChild((OMNode)envelope);
        }
        String XPathString = "//elem1";
        AXIOMXPath XPath = new AXIOMXPath(XPathString);
        OMNode node = (OMNode)XPath.selectSingleNode((Object)envelope);
        TestXPathAppliedToSOAPEnvelope.assertNotNull((Object)node);
    }
}

