/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.message;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.InputStream;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.ExpansionStrategy;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.soap.SOAPSample;

public class TestSerialize
extends AxiomTestCase {
    private final SOAPSample message;
    private final ExpansionStrategy expansionStrategy;
    private final SerializationStrategy serializationStrategy;

    public TestSerialize(OMMetaFactory metaFactory, SOAPSample message, ExpansionStrategy expansionStrategy, SerializationStrategy serializationStrategy) {
        super(metaFactory);
        this.message = message;
        this.expansionStrategy = expansionStrategy;
        this.serializationStrategy = serializationStrategy;
        this.addTestParameter("message", message.getName());
        expansionStrategy.addTestParameters(this);
        serializationStrategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        SOAPMessage soapMessage = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (InputStream)this.message.getInputStream(), null).getSOAPMessage();
        this.expansionStrategy.apply((OMContainer)soapMessage);
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)this.serializationStrategy.serialize((OMContainer)soapMessage).getInputSource())).ignoringRedundantNamespaceDeclarations().hasSameContentAs((Object)this.message.getInputStream());
        soapMessage.close(false);
    }
}

