/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.headerblock;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.BooleanAttributeAccessor;
import org.apache.axiom.ts.soap.HeaderBlockAttribute;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.headerblock.BooleanAttributeTestCase;

public class TestSetBooleanAttribute
extends BooleanAttributeTestCase {
    private final boolean value;

    public TestSetBooleanAttribute(OMMetaFactory metaFactory, SOAPSpec spec, HeaderBlockAttribute attribute, boolean value) {
        super(metaFactory, spec, attribute);
        this.addTestParameter("value", value);
        this.value = value;
    }

    protected void runTest() throws Throwable {
        SOAPHeaderBlock soapHeaderBlock = this.createSOAPHeaderBlock();
        BooleanAttributeAccessor accessor = (BooleanAttributeAccessor)this.attribute.getAdapter(BooleanAttributeAccessor.class);
        accessor.setValue(soapHeaderBlock, this.value);
        TestSetBooleanAttribute.assertEquals((boolean)this.value, (boolean)accessor.getValue(soapHeaderBlock));
        Iterator it = soapHeaderBlock.getAllAttributes();
        TestSetBooleanAttribute.assertTrue((boolean)it.hasNext());
        OMAttribute att = (OMAttribute)it.next();
        OMNamespace ns = att.getNamespace();
        TestSetBooleanAttribute.assertEquals((String)this.spec.getEnvelopeNamespaceURI(), (String)ns.getNamespaceURI());
        TestSetBooleanAttribute.assertEquals((String)this.attribute.getName(this.spec), (String)att.getLocalName());
        TestSetBooleanAttribute.assertEquals((String)this.spec.getCanonicalRepresentation(this.value), (String)att.getAttributeValue());
        TestSetBooleanAttribute.assertFalse((boolean)it.hasNext());
    }
}

