/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.headerblock;

import com.google.common.truth.Truth;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.ds.BlobOMDataSource;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestBlobOMDataSource
extends SOAPTestCase {
    public TestBlobOMDataSource(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = this.soapFactory.createOMNamespace("urn://test", "tns");
        BlobOMDataSource ds = new BlobOMDataSource(Blobs.createBlob((byte[])payload.getBytes(encoding)), encoding);
        ds.setProperty("org.apache.axiom.soap.SOAPHeader.MUST_UNDERSTAND", null);
        SOAPHeaderBlock omse = this.soapFactory.createSOAPHeaderBlock(localName, ns, (OMDataSource)ds);
        soapHeader.addChild((OMNode)omse);
        OMNode firstChild = soapHeader.getFirstOMChild();
        TestBlobOMDataSource.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof SOAPHeaderBlock));
        SOAPHeaderBlock child = (SOAPHeaderBlock)firstChild;
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)ds);
        TestBlobOMDataSource.assertTrue((!child.getMustUnderstand() ? 1 : 0) != 0);
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)ds);
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestBlobOMDataSource.assertTrue((String)"The payload was not present in the output", (soapHeader.toString().indexOf(payload) > 0 ? 1 : 0) != 0);
        TestBlobOMDataSource.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        Truth.assertThat((Object)child.getDataSource()).isSameInstanceAs((Object)ds);
    }
}

