/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SampleBasedSOAPTestCase;
import org.apache.axiom.ts.soap.header.MyRolePlayer;

public class TestGetHeadersToProcessWithParser
extends SampleBasedSOAPTestCase {
    public TestGetHeadersToProcessWithParser(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec, SOAPSampleSet.HEADERS);
    }

    @Override
    protected void runTest(SOAPEnvelope envelope) throws Throwable {
        SOAPHeader soapHeader = envelope.getHeader();
        String[] roles = new String[]{"http://example.org/myCustomRole"};
        MyRolePlayer rp = new MyRolePlayer(true, roles);
        Iterator headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((String)"No headers!", (boolean)headers.hasNext());
        int numHeaders = 0;
        while (headers.hasNext()) {
            headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (with custom role)", (int)6, (int)numHeaders);
        rp = new MyRolePlayer(true);
        headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((boolean)headers.hasNext());
        numHeaders = 0;
        while (headers.hasNext()) {
            headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (no custom role)", (int)5, (int)numHeaders);
        rp = new MyRolePlayer(false);
        headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((boolean)headers.hasNext());
        numHeaders = 0;
        while (headers.hasNext()) {
            headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (no custom role)", (int)2, (int)numHeaders);
    }
}

