/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.ArrayList;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestGetHeaderBlocksWithNSURI
extends SOAPTestCase {
    public TestGetHeaderBlocksWithNSURI(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        soapHeader.addHeaderBlock("echoOk1", namespace);
        soapHeader.addHeaderBlock("echoOk2", this.soapFactory.createOMNamespace("http://www.test1.org", "test1"));
        ArrayList arrayList = soapHeader.getHeaderBlocksWithNSURI("http://www.test1.org");
        TestGetHeaderBlocksWithNSURI.assertEquals((String)"SOAP Header Test : - getHeaderBlocksWithNSURI returns an arrayList of incorrect size", (int)1, (int)arrayList.size());
        TestGetHeaderBlocksWithNSURI.assertEquals((String)"SOAP Header Test : - headerBlock of given namespace uri mismatch", (String)"http://www.test1.org", (String)((SOAPHeaderBlock)arrayList.get(0)).getNamespace().getNamespaceURI());
    }
}

