/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import com.google.common.truth.Truth;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SampleBasedSOAPTestCase;

public class TestExamineHeaderBlocksWithParser
extends SampleBasedSOAPTestCase {
    public TestExamineHeaderBlocksWithParser(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec, SOAPSampleSet.HEADERS);
    }

    @Override
    protected void runTest(SOAPEnvelope envelope) throws Throwable {
        String roleNextURI = this.spec.getNextRoleURI();
        Iterator it = envelope.getHeader().examineHeaderBlocks(roleNextURI);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)it.next();
        Truth.assertThat((Object)headerBlock.getQName()).isEqualTo((Object)new QName("http://example.org/RoleTest", "h2"));
        Truth.assertThat((String)headerBlock.getRole()).isEqualTo((Object)roleNextURI);
        Truth.assertThat((Boolean)it.hasNext()).isTrue();
        headerBlock = (SOAPHeaderBlock)it.next();
        Truth.assertThat((Object)headerBlock.getQName()).isEqualTo((Object)new QName("http://example.org/RoleTest", "h7"));
        Truth.assertThat((String)headerBlock.getRole()).isEqualTo((Object)roleNextURI);
        Truth.assertThat((Boolean)it.hasNext()).isFalse();
    }
}

