/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestExamineAllHeaderBlocks
extends SOAPTestCase {
    public TestExamineAllHeaderBlocks(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        soapHeader.addHeaderBlock("echoOk1", namespace);
        soapHeader.addHeaderBlock("echoOk2", namespace);
        Iterator iterator = soapHeader.examineAllHeaderBlocks();
        TestExamineAllHeaderBlocks.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        TestExamineAllHeaderBlocks.assertNotNull((String)"SOAP Header Test : - After calling addHeaderBlock method twice, examineAllHeaderBlocks method returns empty iterator", (Object)headerBlock1);
        TestExamineAllHeaderBlocks.assertEquals((String)"SOAP Header Test : - HeaderBlock1 local name mismatch", (String)"echoOk1", (String)headerBlock1.getLocalName());
        TestExamineAllHeaderBlocks.assertEquals((String)"SOAP Header Test : - HeaderBlock1 namespace uri mismatch", (String)"http://www.example.org", (String)headerBlock1.getNamespace().getNamespaceURI());
        TestExamineAllHeaderBlocks.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        TestExamineAllHeaderBlocks.assertNotNull((String)"SOAP Header Test : - After calling addHeaderBlock method twice, examineAllHeaderBlocks method returns an iterator with only one object", (Object)headerBlock2);
        TestExamineAllHeaderBlocks.assertEquals((String)"SOAP Header Test : - HeaderBlock2 local name mismatch", (String)"echoOk2", (String)headerBlock2.getLocalName());
        TestExamineAllHeaderBlocks.assertEquals((String)"SOAP Header Test : - HeaderBlock2 namespace uri mismatch", (String)"http://www.example.org", (String)headerBlock2.getNamespace().getNamespaceURI());
        TestExamineAllHeaderBlocks.assertFalse((String)"SOAP Header Test : - After calling addHeaderBlock method twice, examineAllHeaderBlocks method returns an iterator with more than two object", (boolean)iterator.hasNext());
    }
}

