/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestAddHeaderBlock
extends SOAPTestCase {
    public TestAddHeaderBlock(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        SOAPHeaderBlock headerBlock1 = soapHeader.addHeaderBlock("echoOk1", namespace);
        SOAPHeaderBlock headerBlock2 = soapHeader.addHeaderBlock("echoOk2", namespace);
        Iterator iterator = soapHeader.getChildren();
        TestAddHeaderBlock.assertSame((Object)headerBlock1, iterator.next());
        TestAddHeaderBlock.assertSame((Object)soapHeader, (Object)headerBlock1.getParent());
        TestAddHeaderBlock.assertNotNull((String)"SOAP Header Test : - After calling addHeaderBlock method twice, getChildren method returns empty iterator", (Object)headerBlock1);
        TestAddHeaderBlock.assertEquals((String)"SOAP Header Test : - HeaderBlock1 local name mismatch", (String)"echoOk1", (String)headerBlock1.getLocalName());
        TestAddHeaderBlock.assertEquals((String)"SOAP Header Test : - HeaderBlock1 namespace uri mismatch", (String)"http://www.example.org", (String)headerBlock1.getNamespace().getNamespaceURI());
        TestAddHeaderBlock.assertSame((Object)headerBlock2, iterator.next());
        TestAddHeaderBlock.assertSame((Object)soapHeader, (Object)headerBlock2.getParent());
        TestAddHeaderBlock.assertNotNull((String)"SOAP Header Test : - After calling addHeaderBlock method twice, getChildren method returns an iterator with only one object", (Object)headerBlock2);
        TestAddHeaderBlock.assertEquals((String)"SOAP Header Test : - HeaderBlock2 local name mismatch", (String)"echoOk2", (String)headerBlock2.getLocalName());
        TestAddHeaderBlock.assertEquals((String)"SOAP Header Test : - HeaderBlock2 namespace uri mismatch", (String)"http://www.example.org", (String)headerBlock2.getNamespace().getNamespaceURI());
        TestAddHeaderBlock.assertFalse((String)"SOAP Header Test : - After calling addHeaderBlock method twice, getChildren method returns an iterator with more than two elements", (boolean)iterator.hasNext());
    }
}

