/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.faultdetail;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestSerialization
extends SOAPTestCase {
    public TestSerialization(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPBody body = this.soapFactory.createSOAPBody(envelope);
        SOAPFault fault = this.soapFactory.createSOAPFault(body);
        SOAPFaultDetail soapFaultDetail = this.soapFactory.createSOAPFaultDetail(fault);
        OMNamespace omNamespace = this.soapFactory.createOMNamespace("http://www.test.org", "test");
        soapFaultDetail.addDetailEntry(this.soapFactory.createOMElement("DetailEntry1", omNamespace));
        soapFaultDetail.addDetailEntry(this.soapFactory.createOMElement("DetailEntry2", omNamespace));
        StringWriter out = new StringWriter();
        soapFaultDetail.serialize((Writer)out);
        String msg = out.toString();
        TestSerialization.assertTrue((msg.indexOf("DetailEntry1") != -1 ? 1 : 0) != 0);
        TestSerialization.assertTrue((msg.indexOf("DetailEntry2") != -1 ? 1 : 0) != 0);
    }
}

