/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.faultdetail;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestAddDetailEntry
extends SOAPTestCase {
    public TestAddDetailEntry(OMMetaFactory omMetaFactory, SOAPSpec spec) {
        super(omMetaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPBody body = this.soapFactory.createSOAPBody(envelope);
        SOAPFault fault = this.soapFactory.createSOAPFault(body);
        SOAPFaultDetail soapFaultDetail = this.soapFactory.createSOAPFaultDetail(fault);
        OMNamespace omNamespace = this.soapFactory.createOMNamespace("http://www.test.org", "test");
        soapFaultDetail.addDetailEntry(this.soapFactory.createOMElement("DetailEntry1", omNamespace));
        soapFaultDetail.addDetailEntry(this.soapFactory.createOMElement("DetailEntry2", omNamespace));
        Iterator iterator = soapFaultDetail.getAllDetailEntries();
        OMElement detailEntry1 = (OMElement)iterator.next();
        TestAddDetailEntry.assertNotNull((String)"SOAP Fault Detail Test : - After calling addDetailEntry method twice, getAllDetailEntries method returns empty iterator", (Object)detailEntry1);
        TestAddDetailEntry.assertEquals((String)"SOAP Fault Detail Test : - detailEntry1 local name mismatch", (String)"DetailEntry1", (String)detailEntry1.getLocalName());
        TestAddDetailEntry.assertEquals((String)"SOAP Fault Detail Test : - detailEntry1 namespace uri mismatch", (String)"http://www.test.org", (String)detailEntry1.getNamespace().getNamespaceURI());
        OMElement detailEntry2 = (OMElement)iterator.next();
        TestAddDetailEntry.assertNotNull((String)"SOAP Fault Detail Test : - After calling addDetailEntry method twice, getAllDetailEntries method returns an iterator with only one object", (Object)detailEntry2);
        TestAddDetailEntry.assertEquals((String)"SOAP Fault Detail Test : - detailEntry2 local name mismatch", (String)"DetailEntry2", (String)detailEntry2.getLocalName());
        TestAddDetailEntry.assertEquals((String)"SOAP Fault Detail Test : - detailEntry2 namespace uri mismatch", (String)"http://www.test.org", (String)detailEntry2.getNamespace().getNamespaceURI());
        TestAddDetailEntry.assertFalse((String)"SOAP Fault Detail Test : - After calling addDetailEntry method twice, getAllDetailEntries method returns an iterator with three objects", (boolean)iterator.hasNext());
    }
}

