/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.factory;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestCreateSOAPEnvelopeWithCustomPrefix
extends SOAPTestCase {
    public TestCreateSOAPEnvelopeWithCustomPrefix(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        String prefix = "my-soap";
        OMNamespace ns = this.soapFactory.createOMNamespace(this.spec.getEnvelopeNamespaceURI(), prefix);
        SOAPEnvelope env = this.soapFactory.createSOAPEnvelope(ns);
        TestCreateSOAPEnvelopeWithCustomPrefix.assertEquals((String)prefix, (String)env.getNamespace().getPrefix());
        TestCreateSOAPEnvelopeWithCustomPrefix.assertEquals((String)this.spec.getEnvelopeNamespaceURI(), (String)env.getNamespace().getNamespaceURI());
        TestCreateSOAPEnvelopeWithCustomPrefix.assertEquals((String)"Envelope", (String)env.getLocalName());
        Iterator it = env.getAllDeclaredNamespaces();
        TestCreateSOAPEnvelopeWithCustomPrefix.assertTrue((boolean)it.hasNext());
        TestCreateSOAPEnvelopeWithCustomPrefix.assertEquals((Object)ns, it.next());
        TestCreateSOAPEnvelopeWithCustomPrefix.assertFalse((boolean)it.hasNext());
    }
}

