/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.OutputStream;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestSerializeAsChild
extends SOAPTestCase {
    public TestSerializeAsChild(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createDefaultSOAPMessage().getSOAPEnvelope();
        this.soapFactory.createOMElement("echo", this.soapFactory.createOMNamespace("urn:test", "p"), (OMContainer)envelope.getBody());
        OMElement log = this.soapFactory.createOMElement("log", null);
        OMElement entry = this.soapFactory.createOMElement("entry", null, (OMContainer)log);
        entry.addChild((OMNode)envelope);
        MemoryBlob blob = Blobs.createMemoryBlob();
        MemoryBlobOutputStream out = blob.getOutputStream();
        envelope.serialize((OutputStream)out);
        out.close();
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)blob.getInputStream())).hasSameContentAs(XMLTruth.xml(OMElement.class, (Object)envelope));
    }
}

