/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestGetSOAPBodyFirstElementLocalNameAndNS
extends SOAPTestCase {
    private final QName qname;

    public TestGetSOAPBodyFirstElementLocalNameAndNS(OMMetaFactory metaFactory, SOAPSpec spec, QName qname) {
        super(metaFactory, spec);
        this.qname = qname;
        this.addTestParameter("prefix", qname.getPrefix());
        this.addTestParameter("uri", qname.getNamespaceURI());
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.getDefaultEnvelope();
        OMElement bodyElement = this.soapFactory.createOMElement(this.qname.getLocalPart(), this.qname.getNamespaceURI(), this.qname.getPrefix());
        envelope.getBody().addChild((OMNode)bodyElement);
        TestGetSOAPBodyFirstElementLocalNameAndNS.assertEquals((String)this.qname.getLocalPart(), (String)envelope.getSOAPBodyFirstElementLocalName());
        OMNamespace ns = envelope.getSOAPBodyFirstElementNS();
        if (this.qname.getNamespaceURI().length() == 0) {
            TestGetSOAPBodyFirstElementLocalNameAndNS.assertNull((Object)ns);
        } else {
            TestGetSOAPBodyFirstElementLocalNameAndNS.assertEquals((String)this.qname.getNamespaceURI(), (String)ns.getNamespaceURI());
            TestGetSOAPBodyFirstElementLocalNameAndNS.assertEquals((String)this.qname.getPrefix(), (String)ns.getPrefix());
        }
    }
}

