/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.StringOMDataSource;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.envelope.CloneTestCase;

public class TestCloneWithSourcedElement2
extends CloneTestCase {
    public TestCloneWithSourcedElement2(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope sourceEnv = this.soapFactory.getDefaultEnvelope();
        SOAPBody body = sourceEnv.getBody();
        SOAPHeader header = sourceEnv.getHeader();
        StringOMDataSource dsHdr = new StringOMDataSource("<hdr:myheader xmlns:hdr=\"urn://test\">Hello World</hdr:myheader>");
        OMNamespace hdrNS = header.getOMFactory().createOMNamespace("urn://test", "hdr");
        SOAPFactory sf = (SOAPFactory)header.getOMFactory();
        SOAPHeaderBlock shb = sf.createSOAPHeaderBlock("myheader", hdrNS, (OMDataSource)dsHdr);
        shb.setProcessed();
        header.addChild((OMNode)shb);
        StringOMDataSource ds = new StringOMDataSource("<tns:payload xmlns:tns=\"urn://test\">Hello World</tns:payload>");
        OMNamespace ns = body.getOMFactory().createOMNamespace("urn://test", "tns");
        OMSourcedElement omse = body.getOMFactory().createOMElement((OMDataSource)ds, "payload", ns);
        body.addChild((OMNode)omse);
        this.copyAndCheck(sourceEnv);
        TestCloneWithSourcedElement2.assertFalse((boolean)shb.isExpanded());
    }
}

