/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.BlobOMDataSource;
import org.apache.axiom.om.ds.custombuilder.BlobOMDataSourceCustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilderSupport;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSampleAdapter;
import org.xml.sax.InputSource;

public class TestRegisterCustomBuilderForPayload
extends AxiomTestCase {
    private final SOAPSample message;

    public TestRegisterCustomBuilderForPayload(OMMetaFactory metaFactory, SOAPSample message) {
        super(metaFactory);
        this.message = message;
        this.addTestParameter("message", message.getName());
    }

    protected void runTest() throws Throwable {
        SOAPModelBuilder builder = ((SOAPSampleAdapter)this.message.getAdapter(SOAPSampleAdapter.class)).getBuilder(this.metaFactory);
        ((CustomBuilderSupport)builder).registerCustomBuilder(CustomBuilder.Selector.PAYLOAD, (CustomBuilder)new BlobOMDataSourceCustomBuilder(MemoryBlob.FACTORY, "utf-8"));
        SOAPEnvelope envelope = builder.getSOAPEnvelope();
        OMElement payload = envelope.getBody().getFirstElement();
        if (this.message.getPayload() == null) {
            Truth.assertThat((Object)payload).isNull();
        } else if (this.message.getPayload().getLocalName().equals("Fault")) {
            Truth.assertThat((Object)payload).isInstanceOf(SOAPFault.class);
        } else {
            Truth.assertThat((Object)payload).isInstanceOf(OMSourcedElement.class);
            BlobOMDataSource.Data data = (BlobOMDataSource.Data)((OMSourcedElement)payload).getObject(BlobOMDataSource.class);
            Truth.assertThat((Object)data).isNotNull();
            InputSource is = new InputSource(data.getBlob().getInputStream());
            is.setEncoding(data.getEncoding());
            ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)is)).ignoringNamespaceDeclarations().hasSameContentAs((Object)this.message.getPayloadInputSource());
        }
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that((Object)envelope.getXMLStreamReader(false))).ignoringPrologAndEpilog().ignoringRedundantNamespaceDeclarations().hasSameContentAs((Object)this.message.getInputStream());
        if (payload instanceof OMSourcedElement) {
            Truth.assertThat((Boolean)((OMSourcedElement)payload).isExpanded()).isFalse();
        }
    }
}

