/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import java.util.ArrayList;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.ds.custombuilder.BlobOMDataSourceCustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilderSupport;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.ts.soap.SOAPSampleAdapter;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestRegisterCustomBuilder
extends SOAPTestCase {
    public TestRegisterCustomBuilder(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPModelBuilder builder = ((SOAPSampleAdapter)SOAPSampleSet.WSA.getMessage(this.spec).getAdapter(SOAPSampleAdapter.class)).getBuilder(this.metaFactory);
        ((CustomBuilderSupport)builder).registerCustomBuilder(new CustomBuilder.Selector(){

            public boolean accepts(OMContainer parent, int depth, String namespaceURI, String localName) {
                return depth == 3 && namespaceURI.equals("http://www.w3.org/2005/08/addressing") && localName.equals("To");
            }
        }, (CustomBuilder)new BlobOMDataSourceCustomBuilder(MemoryBlob.FACTORY, "utf-8"));
        SOAPHeader header = builder.getSOAPEnvelope().getHeader();
        ArrayList al = header.getHeaderBlocksWithNSURI("http://www.w3.org/2005/08/addressing");
        TestRegisterCustomBuilder.assertEquals((int)al.size(), (int)4);
        for (int i = 0; i < al.size(); ++i) {
            SOAPHeaderBlock shb = (SOAPHeaderBlock)al.get(i);
            if (!"To".equals(shb.getLocalName())) continue;
            TestRegisterCustomBuilder.assertNotNull((Object)shb.getDataSource());
        }
    }
}

