/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.blob.MemoryBlobOutputStream;
import org.apache.axiom.mime.ContentType;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.apache.axiom.util.UIDGenerator;

public class TestCreateSOAPModelBuilderMTOMContentTypeMismatch
extends SOAPTestCase {
    public TestCreateSOAPModelBuilderMTOMContentTypeMismatch(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        final SOAPSample sample = SOAPSampleSet.NO_HEADER.getMessage(this.spec);
        MimeMessage message = new MimeMessage((Session)null);
        MimeMultipart mp = new MimeMultipart("related");
        MimeBodyPart bp = new MimeBodyPart();
        String contentID = "<" + UIDGenerator.generateContentId() + ">";
        bp.setDataHandler(new DataHandler(new DataSource(){

            public String getContentType() {
                return "application/xop+xml; charset=\"" + sample.getEncoding() + "\"; type=\"" + TestCreateSOAPModelBuilderMTOMContentTypeMismatch.this.spec.getAltSpec().getContentType() + "\"";
            }

            public InputStream getInputStream() throws IOException {
                return sample.getInputStream();
            }

            public String getName() {
                return null;
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }
        }));
        bp.addHeader("Content-Transfer-Encoding", "binary");
        bp.addHeader("Content-ID", contentID);
        mp.addBodyPart((BodyPart)bp);
        message.setContent((Multipart)mp);
        message.saveChanges();
        ContentType contentType = new ContentType(message.getContentType()).toBuilder().setParameter("type", "application/xop+xml").setParameter("start", contentID).setParameter("start-info", this.spec.getAltSpec().getContentType()).build();
        MemoryBlob blob = Blobs.createMemoryBlob();
        MemoryBlobOutputStream out = blob.getOutputStream();
        mp.writeTo((OutputStream)out);
        out.close();
        try {
            OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (MultipartBody)MultipartBody.builder().setInputStream((InputStream)blob.getInputStream()).setContentType(contentType).build());
            TestCreateSOAPModelBuilderMTOMContentTypeMismatch.fail((String)"Expected SOAPProcessingException");
        }
        catch (SOAPProcessingException sOAPProcessingException) {
            // empty catch block
        }
    }
}

