/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.jaxp.sax.SAXImplementation;
import org.apache.axiom.ts.soap.SOAPSample;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestCreateSOAPModelBuilderFromSAXSource
extends SOAPTestCase {
    public TestCreateSOAPModelBuilderFromSAXSource(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SAXParserFactory parserFactory = SAXImplementation.XERCES.newSAXParserFactory();
        parserFactory.setNamespaceAware(true);
        XMLReader reader = parserFactory.newSAXParser().getXMLReader();
        SOAPSample sample = SOAPSampleSet.SIMPLE_FAULT.getMessage(this.spec);
        InputStream in = sample.getInputStream();
        InputSource is = new InputSource(in);
        is.setEncoding(sample.getEncoding());
        SOAPMessage message = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Source)new SAXSource(reader, is)).getSOAPMessage();
        ((XMLSubject)Truth.assertAbout((Subject.Factory)XMLTruth.xml()).that(XMLTruth.xml(OMDocument.class, (Object)message))).ignoringWhitespaceInPrologAndEpilog().hasSameContentAs((Object)sample.getEnvelope());
        Truth.assertThat((Object)message.getSOAPEnvelope().getBody().getFault()).isNotNull();
    }
}

