/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.body;

import com.google.common.truth.Truth;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.soap.SOAPSampleSet;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SampleBasedSOAPTestCase;

public class TestSerializeWithXSITypeAttribute
extends SampleBasedSOAPTestCase {
    private final SerializationStrategy serializationStrategy;

    public TestSerializeWithXSITypeAttribute(OMMetaFactory metaFactory, SOAPSpec spec, SerializationStrategy serializationStrategy) {
        super(metaFactory, spec, SOAPSampleSet.XSI_TYPE);
        this.serializationStrategy = serializationStrategy;
        serializationStrategy.addTestParameters(this);
    }

    @Override
    protected void runTest(SOAPEnvelope envelope) throws Throwable {
        XML xml = this.serializationStrategy.serialize((OMContainer)envelope.getBody());
        OMElement element = ((OMMetaFactorySPI)this.metaFactory).createOMBuilder(StAXParserConfiguration.DEFAULT, xml.getInputSource()).getDocumentElement().getFirstElement().getFirstElement();
        Truth.assertThat((Object)element.resolveQName(element.getAttributeValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "type")))).isEqualTo((Object)new QName("http://ws.apache.org/axis2/user", "myData"));
    }
}

