/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.body;

import com.google.common.truth.Truth;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.om.ds.custombuilder.CustomBuilder;
import org.apache.axiom.om.ds.custombuilder.CustomBuilderSupport;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public abstract class FirstElementNameWithParserTestCase
extends SOAPTestCase {
    protected final QName qname;
    private final boolean supportsOptimization;

    public FirstElementNameWithParserTestCase(OMMetaFactory metaFactory, SOAPSpec spec, QName qname, boolean supportsOptimization) {
        super(metaFactory, spec);
        this.qname = qname;
        this.addTestParameter("prefix", qname.getPrefix());
        this.addTestParameter("uri", qname.getNamespaceURI());
        this.addTestParameter("localName", qname.getLocalPart());
        this.supportsOptimization = supportsOptimization;
    }

    protected final void runTest() throws Throwable {
        SOAPEnvelope orgEnvelope = this.soapFactory.getDefaultEnvelope();
        orgEnvelope.getBody().addChild((OMNode)this.soapFactory.createOMElement(this.qname.getLocalPart(), this.qname.getNamespaceURI(), this.qname.getPrefix()));
        SOAPModelBuilder builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Reader)new StringReader(orgEnvelope.toString()));
        SOAPBody body = builder.getSOAPEnvelope().getBody();
        this.runTest(body);
        if (this.supportsOptimization) {
            ((CustomBuilderSupport)builder).registerCustomBuilder(CustomBuilder.Selector.PAYLOAD, new CustomBuilder(){

                public OMDataSource create(OMElement element) throws OMException {
                    try {
                        element.getXMLStreamReaderWithoutCaching().close();
                    }
                    catch (XMLStreamException ex) {
                        throw new OMException((Throwable)ex);
                    }
                    return new AbstractPushOMDataSource(){

                        public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
                            xmlWriter.writeEmptyElement(FirstElementNameWithParserTestCase.this.qname.getPrefix(), FirstElementNameWithParserTestCase.this.qname.getLocalPart(), FirstElementNameWithParserTestCase.this.qname.getNamespaceURI());
                        }

                        public boolean isDestructiveWrite() {
                            return false;
                        }
                    };
                }
            });
            Truth.assertThat((Object)body.getFirstElement()).isInstanceOf(OMSourcedElement.class);
        }
    }

    protected abstract void runTest(SOAPBody var1) throws Throwable;
}

