/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPMessage;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.testing.multiton.AdapterType;
import org.apache.axiom.ts.soap.SOAPSample;
import org.junit.Assert;
import org.xml.sax.InputSource;

@AdapterType
public final class SOAPSampleAdapter {
    private final SOAPSample sample;

    SOAPSampleAdapter(SOAPSample sample) {
        this.sample = sample;
    }

    public SOAPModelBuilder getBuilder(OMMetaFactory metaFactory) {
        return ((OMMetaFactorySPI)metaFactory).createSOAPModelBuilder(new InputSource(this.sample.getInputStream()));
    }

    public SOAPMessage getSOAPMessage(OMMetaFactory metaFactory) {
        return this.getBuilder(metaFactory).getSOAPMessage();
    }

    public SOAPEnvelope getSOAPEnvelope(OMMetaFactory metaFactory) {
        SOAPEnvelope envelope = this.getBuilder(metaFactory).getSOAPEnvelope();
        Assert.assertSame((Object)this.sample.getSOAPSpec().getEnvelopeNamespaceURI(), (Object)((SOAPFactory)envelope.getOMFactory()).getSoapVersionURI());
        return envelope;
    }
}

