/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import com.google.auto.service.AutoService;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultClassifier;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.testing.multiton.AdapterFactory;
import org.apache.axiom.testing.multiton.Adapters;
import org.apache.axiom.ts.soap.SOAPElementType;
import org.apache.axiom.ts.soap.SOAPElementTypeAdapter;
import org.apache.axiom.ts.soap.SOAPFaultChild;

@AutoService(value={AdapterFactory.class})
public class SOAPElementTypeAdapterFactory
implements AdapterFactory<SOAPElementType> {
    public void createAdapters(SOAPElementType type, Adapters adapters) {
        if (type == SOAPElementType.ENVELOPE) {
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPEnvelope.class, null, null){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPEnvelope();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    throw new UnsupportedOperationException();
                }
            });
        } else if (type == SOAPElementType.HEADER) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPEnvelope)parent).getHeader();
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPHeader.class, getter, null){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPHeader();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPHeader((SOAPEnvelope)parent);
                }
            });
        } else if (type == SOAPElementType.BODY) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPEnvelope)parent).getBody();
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPBody.class, getter, null){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPBody();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPBody((SOAPEnvelope)parent);
                }
            });
        } else if (type == SOAPElementType.FAULT) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPBody)parent).getFault();
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFault.class, getter, null){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFault();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFault((SOAPBody)parent);
                }
            });
        } else if (type == SOAPFaultChild.CODE) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFault)parent).getCode();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFault)parent).setCode((SOAPFaultCode)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultCode.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultCode();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultCode((SOAPFault)parent);
                }
            });
        } else if (type == SOAPElementType.VALUE) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFaultClassifier)parent).getValue();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFaultClassifier)parent).setValue((SOAPFaultValue)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultValue.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultValue();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    if (parentType == SOAPFaultChild.CODE) {
                        return factory.createSOAPFaultValue((SOAPFaultCode)parent);
                    }
                    return factory.createSOAPFaultValue((SOAPFaultSubCode)parent);
                }
            });
        } else if (type == SOAPElementType.SUB_CODE) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFaultClassifier)parent).getSubCode();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFaultClassifier)parent).setSubCode((SOAPFaultSubCode)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultSubCode.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultSubCode();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    if (parentType == SOAPFaultChild.CODE) {
                        return factory.createSOAPFaultSubCode((SOAPFaultCode)parent);
                    }
                    return factory.createSOAPFaultSubCode((SOAPFaultSubCode)parent);
                }
            });
        } else if (type == SOAPFaultChild.REASON) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFault)parent).getReason();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFault)parent).setReason((SOAPFaultReason)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultReason.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultReason();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultReason((SOAPFault)parent);
                }
            });
        } else if (type == SOAPElementType.TEXT) {
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultText.class, null, null){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultText();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultText((SOAPFaultReason)parent);
                }
            });
        } else if (type == SOAPFaultChild.NODE) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFault)parent).getNode();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFault)parent).setNode((SOAPFaultNode)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultNode.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultNode();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultNode((SOAPFault)parent);
                }
            });
        } else if (type == SOAPFaultChild.ROLE) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFault)parent).getRole();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFault)parent).setRole((SOAPFaultRole)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultRole.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultRole();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultRole((SOAPFault)parent);
                }
            });
        } else if (type == SOAPFaultChild.DETAIL) {
            SOAPElementTypeAdapter.Getter getter = new SOAPElementTypeAdapter.Getter(){

                @Override
                public OMElement invoke(OMElement parent) {
                    return ((SOAPFault)parent).getDetail();
                }
            };
            SOAPElementTypeAdapter.Setter setter = new SOAPElementTypeAdapter.Setter(){

                @Override
                public void invoke(OMElement parent, OMElement child) {
                    ((SOAPFault)parent).setDetail((SOAPFaultDetail)child);
                }
            };
            adapters.add((Object)new SOAPElementTypeAdapter(SOAPFaultDetail.class, getter, setter){

                @Override
                public OMElement create(SOAPFactory factory) {
                    return factory.createSOAPFaultDetail();
                }

                @Override
                public OMElement create(SOAPFactory factory, SOAPElementType parentType, OMElement parent) {
                    return factory.createSOAPFaultDetail((SOAPFault)parent);
                }
            });
        }
    }
}

